/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.nis;

import com.sun.jndi.nis.NISCtx;
import com.sun.jndi.nis.NISMap;
import com.sun.jndi.nis.NISObject;
import com.sun.jndi.toolkit.ctx.Continuation;
import com.sun.jndi.toolkit.dir.ContainmentFilter;
import com.sun.jndi.toolkit.dir.SearchFilter;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.naming.spi.DirectoryManager;

final class NISCtxMail
extends NISCtx {
    private static final boolean debug = false;
    private static final String addrMapname = "mail.byaddr";
    private static final String[] mailAttrIds = new String[]{"mail", "description"};
    private static final String aliasAttrId = "cn";
    private boolean nonull = false;
    private static final String NULLSWITCH = "com.sun.jndi.nis.mailaliases";

    NISCtxMail() {
        this.objectclass.add("rfc822MailGroup");
    }

    protected Attributes c_getAttributes(Name name, String[] stringArray, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setSuccess();
            return this.getMapAttributes(stringArray);
        }
        NISMap nISMap = this.getNISMap();
        String string = name.toString();
        String string2 = nISMap.getEntry(this.getNullTerminated(string));
        Attributes attributes = this.getAttributesFromEntry(string, string2, stringArray);
        continuation.setSuccess();
        return attributes;
    }

    protected Object c_lookup(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setSuccess();
            return this;
        }
        NISMap nISMap = this.getNISMap();
        String string = name.toString();
        String string2 = nISMap.getEntry(this.getNullTerminated(string));
        continuation.setSuccess();
        NISObject nISObject = new NISObject(this, string, string2, this.environment);
        try {
            Attributes attributes = this.getAttributesFromEntry(string, string2, null);
            return DirectoryManager.getObjectInstance(nISObject, name, this, this.environment, attributes);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException("problem generating object using object factory");
            namingException.setRootCause(exception);
            throw continuation.fillInException(namingException);
        }
    }

    protected NamingEnumeration c_search(Name name, Attributes attributes, String[] stringArray, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            Attribute attribute = (attributes = NISCtx.makeCaseIgnore(attributes)).get(aliasAttrId);
            if (attribute != null) {
                NISMap nISMap = this.getNISMap();
                String string = (String)attribute.get();
                try {
                    String string2 = nISMap.getEntry(this.getNullTerminated(string));
                    Attributes attributes2 = this.getAttributesFromEntry(string, string2, null);
                    if (ContainmentFilter.contains(attributes2, attributes)) {
                        SearchResult searchResult = new SearchResult(string, (Object)null, SearchFilter.selectAttributes(attributes2, stringArray));
                        return new NISCtx.SearchEnumerationImpl(searchResult);
                    }
                }
                catch (NamingException namingException) {}
                return new NISCtx.SearchEnumerationImpl();
            }
            Attribute attribute2 = attributes.get(mailAttrIds[0]);
            if (attribute2 != null) {
                NISMap nISMap = new NISMap(this.domainName, this.hostName, addrMapname);
                String string = (String)attribute2.get();
                try {
                    String string3 = nISMap.getEntry(this.getNullTerminated(string));
                    BasicAttributes basicAttributes = new BasicAttributes(true);
                    basicAttributes.put(attribute2);
                    basicAttributes.put(aliasAttrId, string3);
                    basicAttributes.put(this.objectclass);
                    basicAttributes.put("nisMapName", this.mapname);
                    basicAttributes.put("nisMapEntry", String.valueOf(string3) + " " + string);
                    if (ContainmentFilter.contains(basicAttributes, attributes)) {
                        SearchResult searchResult = new SearchResult(string3, (Object)null, SearchFilter.selectAttributes(basicAttributes, stringArray));
                        return new NISCtx.SearchEnumerationImpl(searchResult);
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                return new NISCtx.SearchEnumerationImpl();
            }
        }
        return super.c_search(name, attributes, stringArray, continuation);
    }

    public Attributes getAttributesFromEntry(String string, String string2, String[] stringArray) throws NamingException {
        boolean bl;
        boolean bl2;
        BasicAttributes basicAttributes = new BasicAttributes(true);
        boolean bl3 = bl2 = stringArray == null;
        if (!bl2 && stringArray.length == 0) {
            return basicAttributes;
        }
        boolean bl4 = bl2 || NISCtx.findId(stringArray, mailAttrIds[0]) >= 0;
        boolean bl5 = bl = bl2 || NISCtx.findId(stringArray, mailAttrIds[1]) >= 0;
        if (bl4 || bl) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",\t #", true);
            BasicAttribute basicAttribute = new BasicAttribute(mailAttrIds[0]);
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("#")) {
                    if (!bl || !stringTokenizer.hasMoreElements() || (string3 = stringTokenizer.nextToken("\n").trim()).length() <= 0) break;
                    basicAttributes.put(mailAttrIds[1], string3);
                    break;
                }
                if (string3.equals(" ") || string3.equals("\t") || string3.equals(",")) continue;
                basicAttribute.add(string3);
            }
            if (bl4 && basicAttribute.size() > 0) {
                basicAttributes.put(basicAttribute);
            }
        }
        if (bl2 || NISCtx.findId(stringArray, aliasAttrId) >= 0) {
            basicAttributes.put(aliasAttrId, string);
        }
        if (bl2 || NISCtx.findId(stringArray, "nisMapEntry") >= 0) {
            basicAttributes.put("nisMapEntry", string2);
        }
        if (bl2 || NISCtx.findId(stringArray, "nisMapName") >= 0) {
            basicAttributes.put("nisMapName", this.realMapname);
        }
        if (bl2 || NISCtx.findId(stringArray, "objectClass") >= 0) {
            basicAttributes.put(this.objectclass);
        }
        return basicAttributes;
    }

    protected String[] getIDs() {
        return mailAttrIds;
    }

    private byte[] getNullTerminated(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        if (this.nonull) {
            return byArray;
        }
        int n = string.length();
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = 0;
        return byArray2;
    }

    protected Attribute getPrimaryAttribute(Attributes attributes) {
        return null;
    }

    void init(String string, String string2, String string3, Hashtable hashtable) throws NamingException {
        super.init(string, string2, string3, hashtable);
        if (hashtable != null) {
            this.nonull = "nonull".equals(this.environment.get(NULLSWITCH));
        }
    }

    protected void initMapname(String string) {
        this.realMapname = "mail.aliases";
        this.mapname = "mail.aliases";
    }
}

