/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.nis;

import com.sun.jndi.nis.NISCtx;
import com.sun.jndi.nis.NISMap;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

final class NISCtxNetworks
extends NISCtx {
    private static final String addrMapname = "networks.byaddr";
    private static final String[] networksAttrIds = new String[]{"dc", "ipNetworkNumber", "description"};

    NISCtxNetworks() {
        this.objectclass.add("ipNetwork");
    }

    public Attributes getAttributesFromEntry(String string, String string2, String[] stringArray) throws NamingException {
        Attributes attributes = super.getAttributesFromEntry(string, string2, stringArray);
        return NISCtx.fixDescription(attributes);
    }

    protected String getEntry(NISMap nISMap, String string, String[] stringArray) throws NamingException {
        boolean bl;
        String string2 = nISMap.getEntry(string);
        boolean bl2 = bl = stringArray == null || NISCtx.findId(stringArray, networksAttrIds[2]) >= 0;
        if (!bl) {
            return string2;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            NISMap nISMap2 = new NISMap(this.domainName, this.hostName, this.getSecondaryMapname());
            return nISMap2.getEntry(string3);
        }
        catch (Exception exception) {
            return string2;
        }
    }

    protected String getEntryName() {
        return networksAttrIds[0];
    }

    protected String[] getIDs() {
        return networksAttrIds;
    }

    protected Attribute getPrimaryAttribute(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        Attribute attribute = attributes.get(networksAttrIds[0]);
        if (attribute != null) {
            return attribute;
        }
        return attributes.get("cn");
    }

    protected Attribute getSecondaryAttribute(Attributes attributes) {
        if (attributes != null) {
            return attributes.get(networksAttrIds[1]);
        }
        return null;
    }

    protected String getSecondaryMapname() {
        return addrMapname;
    }

    protected void initMapname(String string) {
        this.realMapname = "networks.byname";
        this.mapname = "networks.byname";
    }
}

