/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.nis;

import com.sun.jndi.nis.NISCtx;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;

final class NISCtxProtocols
extends NISCtx {
    private static final String addrMapname = "protocols.bynumber";
    private static final String[] protocolsAttrIds = new String[]{"cn", "ipProtocolNumber", "description"};

    NISCtxProtocols() {
        this.objectclass.add("ipProtocol");
    }

    public Attributes getAttributesFromEntry(String string, String string2, String[] stringArray) throws NamingException {
        String string3;
        boolean bl = stringArray == null;
        BasicAttributes basicAttributes = new BasicAttributes(true);
        if (!bl && stringArray.length == 0) {
            return basicAttributes;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        BasicAttribute basicAttribute = new BasicAttribute(protocolsAttrIds[0]);
        if (stringTokenizer.hasMoreElements()) {
            string3 = stringTokenizer.nextToken();
            basicAttribute.add(string3);
        }
        if (stringTokenizer.hasMoreElements()) {
            string3 = stringTokenizer.nextToken();
            if (bl || NISCtx.findId(stringArray, protocolsAttrIds[1]) >= 0) {
                basicAttributes.put(protocolsAttrIds[1], string3);
            }
        }
        while (stringTokenizer.hasMoreElements()) {
            string3 = stringTokenizer.nextToken();
            if (string3.charAt(0) == '#') {
                string3 = stringTokenizer.nextToken("\n").trim();
                if (string3.length() <= 0 || !bl && NISCtx.findId(stringArray, protocolsAttrIds[2]) < 0) break;
                basicAttributes.put(protocolsAttrIds[2], string3);
                break;
            }
            basicAttribute.add(string3);
        }
        if (basicAttribute.size() > 0 && (bl || NISCtx.findId(stringArray, protocolsAttrIds[0]) >= 0)) {
            basicAttributes.put(basicAttribute);
        }
        if (bl || NISCtx.findId(stringArray, "nisMapEntry") >= 0) {
            basicAttributes.put("nisMapEntry", string2);
        }
        if (bl || NISCtx.findId(stringArray, "nisMapName") >= 0) {
            basicAttributes.put("nisMapName", this.realMapname);
        }
        if (bl || NISCtx.findId(stringArray, "objectClass") >= 0) {
            basicAttributes.put(this.objectclass);
        }
        return basicAttributes;
    }

    protected String getEntryName() {
        return protocolsAttrIds[0];
    }

    protected String[] getIDs() {
        return protocolsAttrIds;
    }

    protected Attribute getSecondaryAttribute(Attributes attributes) {
        if (attributes != null) {
            return attributes.get(protocolsAttrIds[1]);
        }
        return null;
    }

    protected String getSecondaryMapname() {
        return addrMapname;
    }

    protected void initMapname(String string) {
        this.realMapname = "protocols.byname";
        this.mapname = "protocols.byname";
    }
}

