/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.nis;

import com.sun.jndi.internal.onc.yp.domainname;
import com.sun.jndi.internal.onc.yp.keydat;
import com.sun.jndi.internal.onc.yp.mapname;
import com.sun.jndi.internal.onc.yp.service2;
import com.sun.jndi.internal.onc.yp.valdat;
import com.sun.jndi.internal.onc.yp.ypreq_key;
import com.sun.jndi.internal.onc.yp.ypreq_nokey;
import com.sun.jndi.internal.onc.yp.ypresp_all;
import com.sun.jndi.internal.onc.yp.ypresp_key_val;
import com.sun.jndi.internal.onc.yp.ypresp_val;
import com.sun.jndi.internal.onc.yp.ypstat;
import com.sun.jndi.nis.KeyValuePair;
import com.sun.jndi.nis.VersionHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.InvalidNameException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

class NISMap {
    static VersionHelper helper = VersionHelper.getVersionHelper();
    private String map;
    private String domain;
    private String host;
    private service2 udpHandle = null;

    NISMap(String string, String string2, String string3) {
        this.domain = string;
        this.host = string2;
        this.map = string3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean checkMap(String string, String string2, String string3) throws NamingException {
        boolean bl;
        service2 service22 = null;
        try {
            try {
                service22 = new service2(string2, false);
                service22.YPPROC_NULL();
                ypreq_key ypreq_key2 = new ypreq_key();
                ypreq_key2.domain = new domainname();
                ypreq_key2.map = new mapname();
                ypreq_key2.domain.data = string;
                ypreq_key2.map.data = string3;
                ypreq_key2.key = new keydat();
                ypreq_key2.key.data = new byte[0];
                ypresp_key_val ypresp_key_val2 = service22.YPPROC_FIRST(ypreq_key2);
                bl = ypresp_key_val2.stat.value == 1 || ypresp_key_val2.stat.value == 2;
                Object var7_9 = null;
                if (service22 == null) return bl;
            }
            catch (IOException iOException) {
                CommunicationException communicationException = new CommunicationException();
                communicationException.setRootCause(iOException);
                throw communicationException;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (service22 == null) throw throwable;
            try {
                service22.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        service22.close();
        return bl;
    }

    void close() {
        this.finalize();
    }

    protected void finalize() {
        if (this.udpHandle != null) {
            try {
                this.udpHandle.close();
            }
            catch (IOException iOException) {}
            this.udpHandle = null;
        }
    }

    NamingEnumeration getAllEntries() throws NamingException {
        GetAllWorker getAllWorker = new GetAllWorker();
        Thread thread = helper.createThread(getAllWorker);
        NISMAP_ypresp_all nISMAP_ypresp_all = getAllWorker.getEnumHandle();
        thread.setDaemon(true);
        thread.start();
        return nISMAP_ypresp_all;
    }

    String getEntry(String string) throws NamingException {
        try {
            return this.getEntry(string.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    synchronized String getEntry(byte[] byArray) throws NamingException {
        try {
            if (this.udpHandle == null) {
                this.udpHandle = new service2(this.host, false);
            }
            this.udpHandle.YPPROC_NULL();
            ypreq_key ypreq_key2 = new ypreq_key();
            ypreq_key2.domain = new domainname();
            ypreq_key2.map = new mapname();
            ypreq_key2.domain.data = this.domain;
            ypreq_key2.map.data = this.map;
            ypreq_key2.key = new keydat();
            ypreq_key2.key.data = byArray;
            ypresp_val ypresp_val2 = this.udpHandle.YPPROC_MATCH(ypreq_key2);
            if (ypresp_val2.stat.value == 1) {
                return new String(ypresp_val2.val.data, "UTF8");
            }
            NamingException namingException = NISMap.mapStatusToException(ypresp_val2.stat.value);
            if (namingException != null) {
                throw namingException;
            }
        }
        catch (IOException iOException) {
            this.udpHandle = null;
            CommunicationException communicationException = new CommunicationException();
            communicationException.setRootCause(iOException);
            throw communicationException;
        }
        return null;
    }

    static NamingException mapStatusToException(int n) {
        switch (n) {
            case -1: {
                return new NameNotFoundException("No such map");
            }
            case -2: {
                return new ConfigurationException("No such domain");
            }
            case -3: {
                return new NameNotFoundException("No such key");
            }
            case -4: {
                return new OperationNotSupportedException();
            }
            case -5: {
                return new ConfigurationException("Corrupted Database");
            }
            case -6: {
                return new NamingException("NIS error");
            }
            case -7: {
                return new InvalidNameException();
            }
            case -8: {
                return new ConfigurationException("Unmatched Versions");
            }
            case 0: 
            case 1: 
            case 2: {
                return null;
            }
        }
        return new NamingException("Unknown NIS error code: " + n);
    }

    class GetAllWorker
    implements Runnable {
        private NISMAP_ypresp_all resp;
        private NamingException savedException = null;
        private service2 ypserv;

        GetAllWorker() throws NamingException {
            try {
                this.ypserv = new service2(NISMap.this.host, true);
                this.ypserv.YPPROC_NULL();
                this.resp = new NISMAP_ypresp_all();
            }
            catch (IOException iOException) {
                CommunicationException communicationException = new CommunicationException();
                communicationException.setRootCause(iOException);
                throw communicationException;
            }
        }

        NISMAP_ypresp_all getEnumHandle() throws NamingException {
            return this.resp;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                try {
                    ypreq_nokey ypreq_nokey2 = new ypreq_nokey();
                    ypreq_nokey2.domain = new domainname();
                    ypreq_nokey2.map = new mapname();
                    ypreq_nokey2.domain.data = NISMap.this.domain;
                    ypreq_nokey2.map.data = NISMap.this.map;
                    this.ypserv.YPPROC_ALL(ypreq_nokey2, this.resp);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                Object var2_3 = null;
                if (this.ypserv == null) return;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                if (this.ypserv == null) throw throwable;
                try {
                    this.ypserv.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                this.ypserv.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    class NISMAP_ypresp_all
    extends ypresp_all
    implements NamingEnumeration {
        KeyValuePair keyvalue = null;
        boolean more = true;
        int mycount = 0;
        NamingException exception = null;

        NISMAP_ypresp_all() {
        }

        public void close() {
            this.finalize();
        }

        protected synchronized void finalize() {
            try {
                super.finalize();
            }
            catch (Throwable throwable) {}
            this.more = false;
        }

        public synchronized boolean handle_error(ypstat ypstat2) {
            this.notify();
            this.exception = NISMap.mapStatusToException(ypstat2.value);
            this.more = false;
            return false;
        }

        /*
         * Unable to fully structure code
         */
        public synchronized boolean hasMore() throws NamingException {
            if (this.exception != null) {
                throw (NamingException)this.exception.fillInStackTrace();
            }
            if (this.keyvalue != null) {
                return true;
            }
            if (this.more) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                try {
                    this.wait();
                    continue;
                }
                catch (InterruptedException v0) {}
lbl11:
                // 3 sources

                ** while (this.keyvalue == null && this.more)
            }
lbl12:
            // 1 sources

            this.notify();
            if (this.exception != null) {
                throw (NamingException)this.exception.fillInStackTrace();
            }
            if (this.keyvalue == null) {
                this.more = false;
                return false;
            }
            return true;
        }

        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException namingException) {
                return false;
            }
        }

        public synchronized Object next() throws NamingException {
            while (this.keyvalue == null && this.more) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.notify();
            if (this.exception != null) {
                throw (NamingException)this.exception.fillInStackTrace();
            }
            if (this.keyvalue != null) {
                KeyValuePair keyValuePair = this.keyvalue;
                this.keyvalue = null;
                return keyValuePair;
            }
            return null;
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException namingException) {
                return null;
            }
        }

        /*
         * Unable to fully structure code
         */
        public synchronized boolean process_entry(ypresp_key_val var1_1) {
            if (var1_1 != null && this.more) ** GOTO lbl9
            this.notify();
            this.more = false;
            return false;
lbl-1000:
            // 1 sources

            {
                try {
                    this.wait();
                    continue;
                }
                catch (InterruptedException v0) {}
lbl9:
                // 3 sources

                ** while (this.keyvalue != null && this.more)
            }
lbl10:
            // 1 sources

            this.notify();
            if (!this.more) {
                return false;
            }
            this.keyvalue = new KeyValuePair(valdat.ypdata2string(var1_1.real_key.data), valdat.ypdata2string(var1_1.real_val.data));
            return true;
        }
    }
}

