/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.nis;

import com.sun.jndi.nis.NISAttrGetter;
import com.sun.jndi.nis.NISBaseCtx;
import com.sun.jndi.toolkit.ctx.Continuation;
import com.sun.jndi.toolkit.ctx.HeadTail;
import com.sun.jndi.toolkit.dir.SearchFilter;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.spi.NamingManager;

final class NISObject
extends NISBaseCtx {
    private NISAttrGetter getter;
    private String key;
    private String entry;
    private Attributes attrs;
    private static final CompositeName EMPTY_NAME = new CompositeName();

    NISObject(NISAttrGetter nISAttrGetter, String string, String string2, Hashtable hashtable) {
        super(hashtable);
        this.key = string;
        this.entry = string2;
        this.getter = nISAttrGetter;
    }

    protected Attributes c_getAttributes(Name name, String[] stringArray, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setSuccess();
            return this.getMyAttributes(stringArray);
        }
        continuation.setError((Object)this, name);
        NameNotFoundException nameNotFoundException = new NameNotFoundException();
        throw continuation.fillInException(nameNotFoundException);
    }

    protected Object c_lookup(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setSuccess();
            try {
                return NamingManager.getObjectInstance(this, name, this, this.environment);
            }
            catch (NamingException namingException) {
                throw continuation.fillInException(namingException);
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException("problem generating object using object factory");
                namingException.setRootCause(exception);
                throw continuation.fillInException(namingException);
            }
        }
        continuation.setError((Object)this, name);
        NameNotFoundException nameNotFoundException = new NameNotFoundException();
        throw continuation.fillInException(nameNotFoundException);
    }

    protected NamingEnumeration getBindingList(boolean bl) throws NamingException {
        return new EmptyEnum();
    }

    protected Attributes getMyAttributes(String[] stringArray) throws NamingException {
        if (this.attrs == null) {
            this.attrs = this.getter.getAttributesFromEntry(this.key, this.entry, null);
        }
        if (stringArray == null) {
            return this.attrs;
        }
        return SearchFilter.selectAttributes(this.attrs, stringArray);
    }

    protected String getMyName() {
        return this.key;
    }

    protected NamingEnumeration getNameClassList() throws NamingException {
        return new EmptyEnum();
    }

    public String getNameInNamespace() {
        return this.key;
    }

    protected HeadTail p_parseComponent(Name name, Continuation continuation) throws NamingException {
        return new HeadTail(EMPTY_NAME, name);
    }

    public String toString() {
        return this.entry;
    }

    class EmptyEnum
    extends NISBaseCtx.NISEnum {
        EmptyEnum() {
        }

        public void close() {
        }

        public boolean hasMore() throws NamingException {
            return false;
        }

        public Object next() throws NamingException {
            throw new NoSuchElementException();
        }
    }
}

