/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.url.nis;

import com.sun.jndi.nis.NISDomainServerPair;
import com.sun.jndi.nis.NISInitCtx;
import com.sun.jndi.url.nis.QueryResults;
import com.sun.jndi.url.nis.QueryThread;
import com.sun.jndi.url.nis.nisURLContext;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ResolveResult;

public class nisURLContextFactory
implements ObjectFactory {
    static final int nisBroadcastTimeout = 1000;

    private static NISDomainServerPair findDomainOnSubnet(Hashtable hashtable) {
        try {
            QueryResults queryResults = new QueryResults();
            Thread[] threadArray = new Thread[hashtable.size()];
            Enumeration enumeration = hashtable.keys();
            int n = 0;
            while (n < threadArray.length && enumeration.hasMoreElements()) {
                threadArray[n] = new QueryThread(queryResults, (String)enumeration.nextElement());
                ++n;
            }
            QueryResults queryResults2 = queryResults;
            synchronized (queryResults2) {
                n = 0;
                while (n < threadArray.length) {
                    threadArray[n].start();
                    ++n;
                }
                try {
                    queryResults.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("wait interrupted");
                }
                n = 0;
                while (n < threadArray.length) {
                    threadArray[n].stop();
                    ++n;
                }
            }
            return queryResults.first;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (object == null) {
            return new nisURLContext(hashtable);
        }
        if (object instanceof String) {
            return nisURLContextFactory.getUsingURL((String)object, hashtable);
        }
        if (object instanceof String[]) {
            return nisURLContextFactory.getUsingURLs((String[])object, hashtable);
        }
        throw new IllegalArgumentException("argument must be an NIS URL string or an array of them");
    }

    static Context getUsingURL(String string, Hashtable hashtable) {
        try {
            return new NISInitCtx(string, hashtable, true, true);
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    static ResolveResult getUsingURLIgnoreRest(String string, Hashtable hashtable) throws NamingException {
        String string2;
        String string3;
        int n;
        int n2;
        if (string.startsWith("nis:///")) {
            n2 = 7;
            n = 1;
        } else if (string.startsWith("nis://")) {
            n2 = 6;
            n = 2;
        } else if (string.startsWith("nis:/")) {
            n2 = 5;
            n = 1;
        } else if (string.startsWith("nis:")) {
            n2 = 4;
            n = 1;
        } else {
            throw new ConfigurationException("Unsupported URL scheme: " + string);
        }
        int n3 = string.length();
        int n4 = 0;
        int n5 = n2;
        while (n5 < n3 && n4 < n && n5 >= 0) {
            if ((n5 = string.indexOf(47, n5)) < 0) continue;
            ++n5;
            ++n4;
        }
        if (n4 == n && n5 < n3) {
            string3 = string.substring(n5);
            string2 = string.substring(0, n5);
        } else {
            string3 = "";
            string2 = string;
        }
        NISInitCtx nISInitCtx = new NISInitCtx(string2, hashtable, true, true);
        return new ResolveResult((Object)nISInitCtx, string3);
    }

    static Context getUsingURLs(String[] stringArray, Hashtable hashtable) {
        Object object;
        Object object2;
        Object object3;
        int n = stringArray.length;
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>(n);
        int n2 = 0;
        while (n2 < n) {
            object3 = stringArray[n2];
            object2 = NISDomainServerPair.parseURL((String)object3);
            if (object2 != null) {
                object = (NISDomainServerPair)hashtable2.get(((NISDomainServerPair)object2).domain);
                if (object == null) {
                    hashtable2.put(((NISDomainServerPair)object2).domain, object2);
                } else {
                    ((NISDomainServerPair)object).addServer(((NISDomainServerPair)object2).server);
                }
            }
            ++n2;
        }
        object3 = nisURLContextFactory.findDomainOnSubnet(hashtable2);
        if (object3 != null) {
            object2 = nisURLContextFactory.makeNISURL(((NISDomainServerPair)object3).domain, ((NISDomainServerPair)object3).server);
            object = new NISInitCtx(((NISDomainServerPair)object3).domain, ((NISDomainServerPair)object3).server, hashtable);
            return object;
        }
        object2 = hashtable2.elements();
        while (object2.hasMoreElements()) {
            object = (NISDomainServerPair)object2.nextElement();
            Enumeration enumeration = ((NISDomainServerPair)object).getServers();
            while (enumeration.hasMoreElements()) {
                try {
                    String string = nisURLContextFactory.makeNISURL(((NISDomainServerPair)object).domain, (String)enumeration.nextElement());
                    NISInitCtx nISInitCtx = new NISInitCtx(string, hashtable, false, true);
                    return nISInitCtx;
                }
                catch (NamingException namingException) {}
            }
        }
        return null;
    }

    static String makeNISURL(String string, String string2) {
        return "nis://" + string2 + "/" + string;
    }
}

