/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.integration;

import java.io.IOException;
import java.io.Serializable;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jsr107.tck.integration.CacheLoaderClient;
import org.jsr107.tck.integration.CacheLoaderServer;
import org.jsr107.tck.integration.RecordingCacheLoader;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CacheLoaderWithExpiryTest {
    @Rule
    public ExcludeListExcluder rule = new ExcludeListExcluder(CacheLoaderWithExpiryTest.class);
    private CacheManager cacheManager;
    private CacheLoaderServer<String, String> cacheLoaderServer;
    private Cache<String, String> cache;

    @Before
    public void onBeforeEachTest() throws IOException {
        this.cacheLoaderServer = new CacheLoaderServer(10000);
        this.cacheLoaderServer.open();
        this.cacheManager = Caching.getCachingProvider().getCacheManager();
        CacheLoaderClient cacheLoader = new CacheLoaderClient(this.cacheLoaderServer.getInetAddress(), this.cacheLoaderServer.getPort());
        MutableConfiguration configuration = new MutableConfiguration();
        configuration.setTypes(String.class, String.class);
        configuration.setCacheLoaderFactory(FactoryBuilder.factoryOf((Serializable)cacheLoader));
        configuration.setReadThrough(true);
        configuration.setExpiryPolicyFactory(FactoryBuilder.factoryOf(ExpireOnAccessPolicy.class));
        this.cacheManager.createCache("cache-loader-test", (Configuration)configuration);
        this.cache = this.cacheManager.getCache("cache-loader-test", String.class, String.class);
    }

    @After
    public void onAfterEachTest() {
        String cacheName = this.cache.getName();
        this.cacheManager.destroyCache(cacheName);
        this.cacheLoaderServer.close();
        this.cacheLoaderServer = null;
        this.cache = null;
    }

    @Test
    public void shouldLoadWhenMissCausedByExpiry() {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        String key = "message";
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        String initialValue = "gudday";
        this.cache.put((Object)key, (Object)initialValue);
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)true));
        String value = (String)this.cache.get((Object)key);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)initialValue));
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        String loadedValue = (String)this.cache.get((Object)key);
        Assert.assertThat((Object)loadedValue, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)key)));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)true));
    }

    public static class ExpireOnAccessPolicy
    implements ExpiryPolicy {
        public Duration getExpiryForCreation() {
            return Duration.ETERNAL;
        }

        public Duration getExpiryForAccess() {
            return Duration.ZERO;
        }

        public Duration getExpiryForUpdate() {
            return Duration.ETERNAL;
        }
    }
}

