/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.integration;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CompletionListener;
import javax.cache.integration.CompletionListenerFuture;
import javax.cache.processor.EntryProcessor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jsr107.tck.integration.CacheLoaderClient;
import org.jsr107.tck.integration.CacheLoaderServer;
import org.jsr107.tck.integration.FailingCacheLoader;
import org.jsr107.tck.integration.NullValueCacheLoader;
import org.jsr107.tck.integration.RecordingCacheLoader;
import org.jsr107.tck.processor.GetEntryProcessor;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CacheLoaderTest {
    @Rule
    public ExcludeListExcluder rule = new ExcludeListExcluder(CacheLoaderTest.class);
    private CacheManager cacheManager;
    private CacheLoaderServer<String, String> cacheLoaderServer;
    private Cache<String, String> cache;

    @Before
    public void onBeforeEachTest() throws IOException {
        this.cacheLoaderServer = new CacheLoaderServer(10000);
        this.cacheLoaderServer.open();
        this.cacheManager = Caching.getCachingProvider().getCacheManager();
        CacheLoaderClient cacheLoader = new CacheLoaderClient(this.cacheLoaderServer.getInetAddress(), this.cacheLoaderServer.getPort());
        MutableConfiguration configuration = new MutableConfiguration();
        configuration.setTypes(String.class, String.class);
        configuration.setCacheLoaderFactory(FactoryBuilder.factoryOf((Serializable)cacheLoader));
        configuration.setReadThrough(true);
        this.cacheManager.createCache("cache-loader-test", (Configuration)configuration);
        this.cache = this.cacheManager.getCache("cache-loader-test", String.class, String.class);
    }

    @After
    public void onAfterEachTest() {
        String cacheName = this.cache.getName();
        this.cacheManager.destroyCache(cacheName);
        this.cacheLoaderServer.close();
        this.cacheLoaderServer = null;
        this.cache = null;
    }

    @Test
    public void shouldLoadWhenCacheMissUsingGet() {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        String key = "message";
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        String value = (String)this.cache.get((Object)key);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)key)));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldLoadWhenAccessingWithEntryProcessor() {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        String key = "message";
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        String value = (String)this.cache.invoke((Object)key, (EntryProcessor)new GetEntryProcessor(), new Object[0]);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)key)));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldNotLoadUsingGetWithExistingValue() {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        String key = "message";
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        this.cache.put((Object)key, (Object)key);
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)true));
        String value = (String)this.cache.get((Object)key);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)key)));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldNotLoadUsingContainsKey() {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        String key = "message";
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldLoadUsingGetAll() {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        HashSet<String> keys = new HashSet<String>();
        keys.add("gudday");
        keys.add("hello");
        keys.add("howdy");
        keys.add("bonjour");
        Map map = this.cache.getAll(keys);
        Assert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)keys.size()));
        for (String key : keys) {
            Assert.assertThat((Object)map.containsKey(key), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat(map.get(key), (Matcher)CoreMatchers.is((Object)key));
        }
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)keys.size()));
        for (String key : keys) {
            Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)true));
        }
        this.cache.getAll(keys);
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)keys.size()));
    }

    @Test
    public void shouldNotLoadWithNullKeyUsingGetAll() {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        HashSet<String> keys = new HashSet<String>();
        keys.add("gudday");
        keys.add("hello");
        keys.add("howdy");
        keys.add("bonjour");
        keys.add(null);
        try {
            Map map = this.cache.getAll(keys);
            Assert.fail((String)"Should have thrown a NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
            for (String key : keys) {
                Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)false));
            }
        }
    }

    @Test
    public void shouldNotLoadDueToIteration() {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        this.cache.put((Object)"gudday", (Object)"gudday");
        this.cache.put((Object)"hello", (Object)"hello");
        this.cache.put((Object)"howdy", (Object)"howdy");
        this.cache.put((Object)"bonjour", (Object)"bonjour");
        HashSet<Object> keys = new HashSet<Object>();
        for (Cache.Entry entry : this.cache) {
            keys.add(entry.getKey());
        }
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        for (String key : keys) {
            Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void shouldNotLoadNullValues() {
        NullValueCacheLoader cacheLoader = new NullValueCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        HashSet<String> keys = new HashSet<String>();
        keys.add("gudday");
        keys.add("hello");
        keys.add("howdy");
        keys.add("bonjour");
        Map map = this.cache.getAll(keys);
        Assert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void shouldNotLoadUsingGetAndPut() {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        String key = "message";
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        String value = (String)this.cache.getAndPut((Object)key, (Object)key);
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)false));
        value = (String)this.cache.getAndPut((Object)key, (Object)key);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)key));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldNotLoadUsingGetAndRemove() {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        String key = "message";
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        String value = (String)this.cache.getAndRemove((Object)key);
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)false));
        this.cache.put((Object)key, (Object)key);
        value = (String)this.cache.getAndRemove((Object)key);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)key));
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldNotLoadUsingGetAndReplace() {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        String key = "message";
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        String value = (String)this.cache.getAndReplace((Object)key, (Object)key);
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)false));
        this.cache.put((Object)key, (Object)key);
        value = (String)this.cache.getAndReplace((Object)key, (Object)"gudday");
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)key));
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldNotLoadUsingPut() {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        String key = "message";
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        this.cache.put((Object)key, (Object)key);
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Object)key));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)false));
        this.cache.put((Object)key, (Object)"gudday");
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldNotLoadUsingPutIfAbsent() {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        String key = "message";
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        this.cache.putIfAbsent((Object)key, (Object)key);
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Object)key));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)false));
        this.cache.putIfAbsent((Object)key, (Object)key);
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldNotLoadUsingPutAll() {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("gudday", "gudday");
        map.put("hello", "hello");
        map.put("howdy", "howdy");
        map.put("bonjour", "bonjour");
        for (String key : map.keySet()) {
            Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        }
        this.cache.putAll(map);
        for (String key : map.keySet()) {
            Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is(map.get(key)));
        }
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        for (String key : map.keySet()) {
            Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void shouldNotLoadUsingReplace() {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        String key = "message";
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        this.cache.put((Object)key, (Object)key);
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)true));
        String value = "other";
        this.cache.replace((Object)key, (Object)value);
        Assert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Object)value));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)false));
        this.cache.replace((Object)key, (Object)value, (Object)key);
        Assert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Object)key));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldNotLoadUsingRemove() {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        String key = "message";
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        this.cache.put((Object)key, (Object)key);
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)true));
        this.cache.remove((Object)key);
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)false));
        this.cache.put((Object)key, (Object)key);
        this.cache.remove((Object)key, (Object)key);
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldNotLoadUsingRemoveAll() {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        this.cache.put((Object)"gudday", (Object)"gudday");
        this.cache.put((Object)"hello", (Object)"hello");
        this.cache.put((Object)"howdy", (Object)"howdy");
        this.cache.put((Object)"bonjour", (Object)"bonjour");
        this.cache.removeAll();
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void shouldLoadSingleMissingEntryUsingLoadAll() throws Exception {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        String key = "message";
        HashSet<String> keys = new HashSet<String>();
        keys.add(key);
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        CompletionListenerFuture future = new CompletionListenerFuture();
        this.cache.loadAll(keys, false, (CompletionListener)future);
        future.get();
        Assert.assertThat((Object)future.isDone(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)key)));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldLoadSingleExistingEntryUsingLoadAll() throws Exception {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        String key = "message";
        HashSet<String> keys = new HashSet<String>();
        keys.add(key);
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        String value = "other";
        this.cache.put((Object)key, (Object)value);
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Object)value));
        CompletionListenerFuture future = new CompletionListenerFuture();
        this.cache.loadAll(keys, true, (CompletionListener)future);
        future.get();
        Assert.assertThat((Object)future.isDone(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)key)));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldLoadMultipleNonExistingEntryUsingLoadAll() throws Exception {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        HashSet<String> keys = new HashSet<String>();
        keys.add("gudday");
        keys.add("hello");
        keys.add("howdy");
        keys.add("bonjour");
        for (String key : keys) {
            Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        }
        CompletionListenerFuture future = new CompletionListenerFuture();
        this.cache.loadAll(keys, false, (CompletionListener)future);
        future.get();
        Assert.assertThat((Object)future.isDone(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)keys.size()));
        for (String key : keys) {
            Assert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)key)));
            Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void shouldLoadMultipleExistingEntryUsingLoadAll() throws Exception {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        HashSet<String> keys = new HashSet<String>();
        keys.add("gudday");
        keys.add("hello");
        keys.add("howdy");
        keys.add("bonjour");
        String value = "other";
        for (String key : keys) {
            Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
            this.cache.put((Object)key, (Object)value);
            Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)true));
        }
        CompletionListenerFuture future = new CompletionListenerFuture();
        this.cache.loadAll(keys, true, (CompletionListener)future);
        future.get();
        Assert.assertThat((Object)future.isDone(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)keys.size()));
        for (String key : keys) {
            Assert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)key)));
            Assert.assertThat((Object)cacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void shouldNotLoadMultipleNullValuesUsingLoadAll() throws Exception {
        NullValueCacheLoader cacheLoader = new NullValueCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        HashSet<String> keys = new HashSet<String>();
        keys.add("gudday");
        keys.add("hello");
        keys.add("howdy");
        keys.add("bonjour");
        CompletionListenerFuture future = new CompletionListenerFuture();
        this.cache.loadAll(keys, false, (CompletionListener)future);
        future.get();
        Assert.assertThat((Object)future.isDone(), (Matcher)CoreMatchers.is((Object)true));
        for (String key : keys) {
            Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void shouldNotLoadMultipleNullEntriesUsingLoadAll() throws Exception {
        NullValueCacheLoader cacheLoader = new NullValueCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        HashSet<String> keys = new HashSet<String>();
        keys.add("gudday");
        keys.add("hello");
        keys.add("howdy");
        keys.add("bonjour");
        CompletionListenerFuture future = new CompletionListenerFuture();
        this.cache.loadAll(keys, false, (CompletionListener)future);
        future.get();
        Assert.assertThat((Object)future.isDone(), (Matcher)CoreMatchers.is((Object)true));
        for (String key : keys) {
            Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotLoadWithNullKeyUsingLoadAll() throws Exception {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        HashSet<Object> keys = new HashSet<Object>();
        keys.add(null);
        try {
            CompletionListenerFuture future = new CompletionListenerFuture();
            this.cache.loadAll(keys, false, (CompletionListener)future);
            Assert.fail((String)"Expected a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        }
    }

    @Test
    public void shouldNotLoadWithNullKeysUsingLoadAll() throws Exception {
        RecordingCacheLoader cacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        try {
            CompletionListenerFuture future = new CompletionListenerFuture();
            this.cache.loadAll(null, false, (CompletionListener)future);
            Assert.fail((String)"Expected a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            Assert.assertThat((Object)cacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)0));
        }
    }

    @Test
    public void shouldPropagateExceptionUsingGet() {
        FailingCacheLoader cacheLoader = new FailingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        try {
            String key = "message";
            this.cache.get((Object)key);
            Assert.fail();
        }
        catch (CacheLoaderException cacheLoaderException) {
            // empty catch block
        }
    }

    @Test
    public void shouldPropagateExceptionUsingLoadAll() throws Exception {
        FailingCacheLoader cacheLoader = new FailingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        HashSet<String> keys = new HashSet<String>();
        keys.add("gudday");
        keys.add("hello");
        keys.add("howdy");
        keys.add("bonjour");
        CompletionListenerFuture future = new CompletionListenerFuture();
        this.cache.loadAll(keys, false, (CompletionListener)future);
        try {
            future.get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(CacheLoaderException.class));
        }
    }

    @Test
    public void testLoadAllWithExecptionAndNoCompletionListener() throws Exception {
        FailingCacheLoader cacheLoader = new FailingCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        HashSet<String> keys = new HashSet<String>();
        keys.add("gudday");
        keys.add("hello");
        keys.add("howdy");
        keys.add("bonjour");
        CompletionListener NULL_COMPLETION_LISTENER = null;
        this.cache.loadAll(keys, false, NULL_COMPLETION_LISTENER);
    }
}

