/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.integration;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CompletionListener;
import javax.cache.integration.CompletionListenerFuture;
import javax.cache.processor.EntryProcessor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jsr107.tck.integration.CacheLoaderClient;
import org.jsr107.tck.integration.CacheLoaderServer;
import org.jsr107.tck.integration.CacheWriterClient;
import org.jsr107.tck.integration.CacheWriterServer;
import org.jsr107.tck.integration.NullValueCacheLoader;
import org.jsr107.tck.integration.RecordingCacheLoader;
import org.jsr107.tck.integration.RecordingCacheWriter;
import org.jsr107.tck.processor.GetEntryProcessor;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CacheLoaderWriterTest {
    @Rule
    public ExcludeListExcluder rule = new ExcludeListExcluder(CacheLoaderWriterTest.class);
    private CacheManager cacheManager;
    private CacheLoaderServer<String, String> cacheLoaderServer;
    private RecordingCacheLoader<String> recordingCacheLoader;
    private CacheWriterServer<String, String> cacheWriterServer;
    private RecordingCacheWriter<String, String> recordingCacheWriter;
    private Cache<String, String> cache;

    @Before
    public void onBeforeEachTest() throws IOException {
        this.recordingCacheLoader = new RecordingCacheLoader();
        this.cacheLoaderServer = new CacheLoaderServer(10000, this.recordingCacheLoader);
        this.cacheLoaderServer.open();
        this.recordingCacheWriter = new RecordingCacheWriter();
        this.cacheWriterServer = new CacheWriterServer(10001, this.recordingCacheWriter);
        this.cacheWriterServer.open();
        this.cacheManager = Caching.getCachingProvider().getCacheManager();
        CacheLoaderClient cacheLoader = new CacheLoaderClient(this.cacheLoaderServer.getInetAddress(), this.cacheLoaderServer.getPort());
        CacheWriterClient cacheWriter = new CacheWriterClient(this.cacheWriterServer.getInetAddress(), this.cacheWriterServer.getPort());
        MutableConfiguration configuration = new MutableConfiguration();
        configuration.setTypes(String.class, String.class);
        configuration.setCacheLoaderFactory(FactoryBuilder.factoryOf((Serializable)cacheLoader));
        configuration.setReadThrough(true);
        configuration.setCacheWriterFactory(FactoryBuilder.factoryOf((Serializable)cacheWriter));
        configuration.setWriteThrough(true);
        this.cacheManager.createCache("cache-loader-writer-test", (Configuration)configuration);
        this.cache = this.cacheManager.getCache("cache-loader-writer-test", String.class, String.class);
    }

    @After
    public void onAfterEachTest() {
        String cacheName = this.cache.getName();
        this.cacheManager.destroyCache(cacheName);
        this.cacheLoaderServer.close();
        this.cacheLoaderServer = null;
        this.cacheWriterServer.close();
        this.cacheWriterServer = null;
        this.cache = null;
    }

    @Test
    public void shouldLoadWhenCacheMissUsingGet() {
        String key = "message";
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        String value = (String)this.cache.get((Object)key);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)key)));
        Assert.assertThat((Object)this.recordingCacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.recordingCacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.recordingCacheWriter.getWriteCount(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.recordingCacheWriter.getDeleteCount(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.recordingCacheWriter.hasWritten((Object)key), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldLoadWhenAccessingWithEntryProcessor() {
        String key = "message";
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        String value = (String)this.cache.invoke((Object)key, (EntryProcessor)new GetEntryProcessor(), new Object[0]);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)key)));
        Assert.assertThat((Object)this.recordingCacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.recordingCacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.recordingCacheWriter.getWriteCount(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.recordingCacheWriter.getDeleteCount(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.recordingCacheWriter.hasWritten((Object)key), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldLoadUsingGetAll() {
        HashSet<String> keys = new HashSet<String>();
        keys.add("gudday");
        keys.add("hello");
        keys.add("howdy");
        keys.add("bonjour");
        Map map = this.cache.getAll(keys);
        Assert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)keys.size()));
        for (String key : keys) {
            Assert.assertThat((Object)map.containsKey(key), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat(map.get(key), (Matcher)CoreMatchers.is((Object)key));
        }
        Assert.assertThat((Object)this.recordingCacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)keys.size()));
        for (String key : keys) {
            Assert.assertThat((Object)this.recordingCacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)true));
        }
        this.cache.getAll(keys);
        Assert.assertThat((Object)this.recordingCacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)keys.size()));
        Assert.assertThat((Object)this.recordingCacheWriter.getWriteCount(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.recordingCacheWriter.getDeleteCount(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void shouldNotLoadNullValues() {
        NullValueCacheLoader cacheLoader = new NullValueCacheLoader();
        this.cacheLoaderServer.setCacheLoader((CacheLoader)cacheLoader);
        HashSet<String> keys = new HashSet<String>();
        keys.add("gudday");
        keys.add("hello");
        keys.add("howdy");
        keys.add("bonjour");
        Map map = this.cache.getAll(keys);
        Assert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)this.recordingCacheWriter.getWriteCount(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.recordingCacheWriter.getDeleteCount(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void shouldLoadSingleMissingEntryUsingLoadAll() throws Exception {
        String key = "message";
        HashSet<String> keys = new HashSet<String>();
        keys.add(key);
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        CompletionListenerFuture future = new CompletionListenerFuture();
        this.cache.loadAll(keys, false, (CompletionListener)future);
        future.get();
        Assert.assertThat((Object)future.isDone(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)key)));
        Assert.assertThat((Object)this.recordingCacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.recordingCacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.recordingCacheWriter.getWriteCount(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.recordingCacheWriter.getDeleteCount(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void shouldNotWriteThroughUsingLoadAll() throws Exception {
        int NUMBER_OF_KEYS = 10;
        Assert.assertEquals((long)0L, (long)this.recordingCacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.recordingCacheWriter.getDeleteCount());
        Assert.assertEquals((long)0L, (long)this.recordingCacheLoader.getLoadCount());
        HashSet<String> keys = new HashSet<String>();
        for (int key = 1; key <= 10; ++key) {
            keys.add(Integer.toString(key));
        }
        Assert.assertEquals((long)0L, (long)this.recordingCacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.recordingCacheWriter.getDeleteCount());
        CompletionListenerFuture future = new CompletionListenerFuture();
        this.cache.loadAll(keys, true, (CompletionListener)future);
        future.get();
        Assert.assertThat((Object)this.recordingCacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)keys.size()));
        for (String key : keys) {
            Assert.assertThat((Object)this.recordingCacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)true));
        }
        Assert.assertEquals((long)0L, (long)this.recordingCacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.recordingCacheWriter.getDeleteCount());
    }

    @Test
    public void shouldLoadSingleExistingEntryUsingLoadAll() throws Exception {
        String key = "message";
        HashSet<String> keys = new HashSet<String>();
        keys.add(key);
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        String value = "other";
        this.cache.put((Object)key, (Object)value);
        Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Object)value));
        CompletionListenerFuture future = new CompletionListenerFuture();
        this.cache.loadAll(keys, true, (CompletionListener)future);
        future.get();
        Assert.assertThat((Object)future.isDone(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)key)));
        Assert.assertThat((Object)this.recordingCacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.recordingCacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.recordingCacheWriter.getWriteCount(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)this.recordingCacheWriter.getDeleteCount(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void shouldLoadMultipleNonExistingEntryUsingLoadAll() throws Exception {
        HashSet<String> keys = new HashSet<String>();
        keys.add("gudday");
        keys.add("hello");
        keys.add("howdy");
        keys.add("bonjour");
        for (String key : keys) {
            Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
        }
        CompletionListenerFuture future = new CompletionListenerFuture();
        this.cache.loadAll(keys, false, (CompletionListener)future);
        future.get();
        Assert.assertThat((Object)future.isDone(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.recordingCacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)keys.size()));
        for (String key : keys) {
            Assert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)key)));
            Assert.assertThat((Object)this.recordingCacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)true));
        }
        Assert.assertThat((Object)this.recordingCacheWriter.getWriteCount(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.recordingCacheWriter.getDeleteCount(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void shouldLoadMultipleExistingEntryUsingLoadAll() throws Exception {
        HashSet<String> keys = new HashSet<String>();
        keys.add("gudday");
        keys.add("hello");
        keys.add("howdy");
        keys.add("bonjour");
        String value = "other";
        for (String key : keys) {
            Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)false));
            this.cache.put((Object)key, (Object)value);
            Assert.assertThat((Object)this.cache.containsKey((Object)key), (Matcher)CoreMatchers.is((Object)true));
        }
        CompletionListenerFuture future = new CompletionListenerFuture();
        this.cache.loadAll(keys, true, (CompletionListener)future);
        future.get();
        Assert.assertThat((Object)future.isDone(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.recordingCacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)keys.size()));
        for (String key : keys) {
            Assert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)key)));
            Assert.assertThat((Object)this.recordingCacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)true));
        }
        Assert.assertThat((Object)this.recordingCacheWriter.getWriteCount(), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)this.recordingCacheWriter.getDeleteCount(), (Matcher)CoreMatchers.is((Object)0L));
    }
}

