/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.rollup;

import com.thoughtworks.selenium.SeleniumException;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import jp.vmi.script.JSList;
import jp.vmi.script.JSMap;
import jp.vmi.selenium.rollup.RollupRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollupManager {
    private static final Logger log = LoggerFactory.getLogger(RollupManager.class);
    private static RollupRules currentRollupRules = null;

    public static synchronized void rollupRulesContext(RollupRules rollupRules, Runnable runnable) {
        currentRollupRules = rollupRules;
        try {
            runnable.run();
        }
        finally {
            currentRollupRules = null;
        }
    }

    public void addRollupRule(Object rule) {
        ScriptEngine engine = RollupManager.currentRollupRules.engine;
        Map ruleMap = JSMap.toMap(engine, rule);
        currentRollupRules.addRule(ruleMap);
        log.info("Added rollup rule: {}", ruleMap.get("name"));
        log.info("- Description: {}", ruleMap.get("description"));
        List args = JSList.toList(engine, ruleMap.get("args"));
        if (args != null && args.size() > 0) {
            log.info("- Arguments:");
            for (Object arg : args) {
                Map argMap = JSMap.toMap(engine, arg);
                log.info("  + {}: {}", argMap.get("name"), argMap.get("description"));
            }
        }
        if (ruleMap.containsKey("expandedCommands")) {
            log.info("- Expanded commands: array");
        } else if (ruleMap.containsKey("getExpandedCommands")) {
            log.info("- Expanded commands: function");
        } else {
            throw new SeleniumException("Missing expandedCommands nor getExpandedCommands in rollup rule definition.");
        }
    }
}

