/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import java.util.Map;
import jp.vmi.selenium.selenese.ModifierKeyState;
import jp.vmi.selenium.selenese.utils.JSFunction;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class EventUtils {
    public static EventUtils eventUtils = new EventUtils();
    private final JSFunction triggerKeyEvent;

    private EventUtils() {
        Map<String, JSFunction> functions = JSFunction.load(EventUtils.class.getResourceAsStream("EventUtils.js"));
        this.triggerKeyEvent = functions.get("triggerKeyEvent");
    }

    public void triggerKeyEvent(WebDriver driver, WebElement element, EventType eventType, String keySequence, ModifierKeyState keyState) {
        int keyCode;
        if (keySequence.codePointCount(0, keySequence.length()) == 1) {
            keyCode = keySequence.codePointAt(0);
        } else {
            try {
                keyCode = keySequence.startsWith("\\") ? Integer.parseInt(keySequence.substring(1)) : Integer.parseInt(keySequence);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("invalid keySequence");
            }
        }
        this.triggerKeyEvent.call(driver, element, eventType.toString(), keyCode, keyState.isControlKeyDown(), keyState.isAltKeyDown(), keyState.isShiftKeyDown(), keyState.isMetaKeyDown());
    }

    public static enum EventType {
        KEYDOWN,
        KEYPRESS,
        KEYUP;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

