/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;
import jp.vmi.selenium.selenese.Runner;
import jp.vmi.selenium.selenese.command.ICommandFactory;
import jp.vmi.selenium.selenese.config.DefaultConfig;
import jp.vmi.selenium.selenese.config.IConfig;
import jp.vmi.selenium.selenese.log.CookieFilter;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.utils.LoggerUtils;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static final String PROG_TITLE = "Selenese Runner";
    private boolean noExit = false;
    private boolean exitStrictly = false;
    private Integer exitCode = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getVersion() {
        try (InputStream is = this.getClass().getResourceAsStream("/META-INF/maven/jp.vmi/selenese-runner-java/pom.properties");){
            if (is == null) return "(missing version information)";
            Properties prop = new Properties();
            prop.load(is);
            String string = prop.getProperty("version");
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "(missing version information)";
    }

    private void help(String ... msgs) {
        String progName = System.getenv("PROG_NAME");
        if (StringUtils.isBlank((CharSequence)progName)) {
            progName = "java -jar selenese-runner.jar";
        }
        new DefaultConfig(new String[0]).showHelp(new PrintWriter(System.out), PROG_TITLE, this.getVersion(), progName, msgs);
        this.exit(1);
    }

    public void run(String[] args) {
        int exitCode = 1;
        try {
            DefaultConfig config = new DefaultConfig(args);
            String[] filenames = config.getArgs();
            if (filenames.length == 0) {
                this.help(new String[0]);
            }
            log.info("Start: Selenese Runner {}", (Object)this.getVersion());
            Runner runner = new Runner();
            runner.setCommandLineArgs(args);
            this.setupRunner(runner, config, filenames);
            Result totalResult = runner.run(filenames);
            runner.finish();
            exitCode = this.exitStrictly ? totalResult.getLevel().strictExitCode : totalResult.getLevel().exitCode;
        }
        catch (IllegalArgumentException e) {
            this.help("Error: " + e.getMessage());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.exit(exitCode);
    }

    public void setupRunner(Runner runner, IConfig config, String ... filenames) {
        int timeout;
        if (config.getMaxTime() != null) {
            long maxTime = NumberUtils.toLong((String)config.getMaxTime(), (long)0L);
            if (maxTime <= 0L) {
                throw new IllegalArgumentException("Invalid max time value. (" + config.getMaxTime() + ")");
            }
            runner.setupMaxTimeTimer(maxTime * 1000L);
        }
        String driverName = config.getDriver();
        DriverOptions driverOptions = new DriverOptions(config);
        if (driverName == null) {
            if (driverOptions.has(DriverOptions.DriverOption.FIREFOX)) {
                driverName = "firefox";
            } else if (driverOptions.has(DriverOptions.DriverOption.CHROMEDRIVER)) {
                driverName = "chrome";
            } else if (driverOptions.has(DriverOptions.DriverOption.IEDRIVER)) {
                driverName = "ie";
            } else if (driverOptions.has(DriverOptions.DriverOption.PHANTOMJS)) {
                driverName = "phantomjs";
            }
        }
        WebDriverManager manager = WebDriverManager.newInstance();
        manager.setWebDriverFactory(driverName);
        manager.setDriverOptions(driverOptions);
        if (config.getCommandFactory() != null) {
            String[] factory;
            String factoryName = config.getCommandFactory();
            try {
                Class<?> factoryClass = Class.forName(factoryName);
                factory = (String[])factoryClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("invalid user defined command factory: " + factoryName);
            }
            runner.getCommandFactory().registerCommandFactory((ICommandFactory)factory);
            log.info("Registered: {}", (Object)factoryName);
        }
        runner.setDriver(manager.get());
        runner.setWebDriverPreparator(manager);
        if (config.isHighlight()) {
            runner.setHighlight(true);
        }
        if (config.isInteractive()) {
            runner.setInteractive(true);
        }
        if (config.getScreenshotDir() != null) {
            runner.setScreenshotDir(config.getScreenshotDir());
        }
        if (config.getScreenshotAll() != null) {
            runner.setScreenshotAllDir(config.getScreenshotAll());
        }
        if (config.getScreenshotOnFail() != null) {
            runner.setScreenshotOnFailDir(config.getScreenshotOnFail());
        }
        if (config.getBaseurl() != null) {
            runner.setOverridingBaseURL(config.getBaseurl());
        }
        if (config.isIgnoreScreenshotCommand()) {
            runner.setIgnoredScreenshotCommand(true);
        }
        if (config.getRollup() != null) {
            String[] rollups;
            for (String rollup : rollups = config.getRollup()) {
                runner.getRollupRules().load(rollup);
            }
        }
        if (config.getCookieFilter() != null) {
            CookieFilter.FilterType filterType;
            String cookieFilter = config.getCookieFilter();
            if (cookieFilter.length() < 2) {
                throw new IllegalArgumentException("invalid cookie filter format: " + cookieFilter);
            }
            switch (cookieFilter.charAt(0)) {
                case '+': {
                    filterType = CookieFilter.FilterType.PASS;
                    break;
                }
                case '-': {
                    filterType = CookieFilter.FilterType.SKIP;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid cookie filter format: " + cookieFilter);
                }
            }
            String pattern = cookieFilter.substring(1);
            runner.setCookieFilter(new CookieFilter(filterType, pattern));
        }
        if (config.getXmlResult() != null) {
            runner.setJUnitResultDir(config.getXmlResult());
        }
        if (config.getHtmlResult() != null) {
            runner.setHtmlResultDir(config.getHtmlResult());
        }
        if ((timeout = NumberUtils.toInt((String)config.getTimeout(), (int)30000)) <= 0) {
            throw new IllegalArgumentException("Invalid timeout value. (" + config.getTimeout() + ")");
        }
        runner.setTimeout(timeout);
        int speed = NumberUtils.toInt((String)config.getSetSpeed(), (int)0);
        if (speed < 0) {
            throw new IllegalArgumentException("Invalid speed value. (" + config.getSetSpeed() + ")");
        }
        runner.setInitialSpeed(speed);
        if (config.isNoExit()) {
            this.noExit = true;
        }
        if (config.isStrictExitCode()) {
            this.exitStrictly = true;
        }
        runner.setPrintStream(System.out);
    }

    protected void exit(int exitCode) {
        this.exitCode = exitCode;
        log.info("Exit code: {}", (Object)exitCode);
        WebDriverManager.quitDriversOnAllManagers();
        if (!this.noExit) {
            System.exit(exitCode);
        }
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public static void main(String[] args) {
        LoggerUtils.initLogger();
        new Main().run(args);
    }
}

