/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import com.thoughtworks.selenium.SeleniumException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.command.ICommand;
import jp.vmi.selenium.selenese.command.Screenshot;
import jp.vmi.selenium.selenese.command.StartLoop;
import jp.vmi.selenium.selenese.locator.WebDriverElementFinder;
import jp.vmi.selenium.selenese.result.Failure;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Unexecuted;
import jp.vmi.selenium.selenese.utils.LoggerUtils;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractCommand
implements ICommand {
    private final int index;
    private final String name;
    private final String[] args;
    private final ArgumentType[] argTypes;
    private final int[] locatorIndexes;
    private Result result = Unexecuted.UNEXECUTED;
    private StartLoop startLoop = StartLoop.NO_START_LOOP;
    private List<Screenshot> screenshots = null;

    public AbstractCommand(int index, String name, String[] args, ArgumentType ... argTypes) {
        this.index = index;
        this.name = name;
        int curLen = args.length;
        int reqLen = argTypes.length;
        if (curLen == reqLen) {
            this.args = args;
        } else {
            this.args = Arrays.copyOf(args, reqLen);
            if (curLen < reqLen) {
                Arrays.fill(this.args, curLen, reqLen, "");
            }
        }
        this.argTypes = argTypes;
        int[] locatorIndexes = new int[argTypes.length];
        int locCnt = 0;
        block4: for (int i = 0; i < argTypes.length; ++i) {
            switch (argTypes[i]) {
                case VALUE: {
                    continue block4;
                }
                case LOCATOR: 
                case ATTRIBUTE_LOCATOR: 
                case CSS_LOCATOR: 
                case OPTION_LOCATOR: {
                    locatorIndexes[locCnt++] = i;
                }
            }
        }
        this.locatorIndexes = Arrays.copyOf(locatorIndexes, locCnt);
    }

    @Override
    public final String[] getSource() {
        String[] source = new String[3];
        source[0] = this.name;
        switch (this.args.length) {
            case 2: 
            case 3: {
                source[2] = this.args[1];
            }
            case 1: {
                source[1] = this.args[0];
            }
        }
        return source;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getArguments() {
        return this.args;
    }

    @Override
    public String[] convertLocators(String[] args) {
        if (this.locatorIndexes.length == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        String[] locators = new String[this.locatorIndexes.length];
        int i = 0;
        block6: for (int locatorIndex : this.locatorIndexes) {
            ArgumentType type = this.argTypes[locatorIndex];
            String arg = args[locatorIndex];
            switch (type) {
                case CSS_LOCATOR: {
                    if (!arg.startsWith("css=")) {
                        arg = "css=" + arg;
                    }
                }
                case LOCATOR: {
                    locators[i++] = arg;
                    continue block6;
                }
                case ATTRIBUTE_LOCATOR: {
                    int at = arg.lastIndexOf(64);
                    locators[i++] = at >= 0 ? arg.substring(0, at) : arg;
                    continue block6;
                }
                case OPTION_LOCATOR: {
                    locators[i] = WebDriverElementFinder.convertToOptionLocatorWithParent(locators[i - 1], arg);
                    ++i;
                    continue block6;
                }
                default: {
                    throw new RuntimeException("Invalid locator type: " + (Object)((Object)type));
                }
            }
        }
        return locators;
    }

    @Override
    public boolean mayUpdateScreen() {
        return true;
    }

    protected abstract Result executeImpl(Context var1, String ... var2);

    @Override
    public final Result execute(Context context, String ... curArgs) {
        try {
            this.result = this.executeImpl(context, curArgs);
        }
        catch (SeleniumException e) {
            this.result = new Failure(e.getMessage().replaceAll("(\r?\n)+", " / "));
        }
        return this.result;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    @Override
    public void setStartLoop(StartLoop startLoop) {
        this.startLoop = startLoop;
    }

    @Override
    public StartLoop getStartLoop() {
        return this.startLoop;
    }

    @Override
    public void addScreenshot(String path, String label) {
        if (path == null) {
            return;
        }
        if (this.screenshots == null) {
            this.screenshots = new ArrayList<Screenshot>();
        }
        this.screenshots.add(new Screenshot(path, label));
    }

    @Override
    public List<Screenshot> getScreenshots() {
        if (this.screenshots == null) {
            return Collections.emptyList();
        }
        return this.screenshots;
    }

    static String toString(int index, String name, String[] args) {
        StringBuilder s = new StringBuilder("Command#").append(index);
        s.append(": ").append(name).append("(");
        boolean sep = false;
        for (String arg : args) {
            if (sep) {
                s.append(", ");
            } else {
                sep = true;
            }
            LoggerUtils.quote(s, arg);
        }
        s.append(')');
        return s.toString();
    }

    public String toString() {
        return AbstractCommand.toString(this.index, this.name, this.args);
    }
}

