/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.WaitForPageToLoad;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import jp.vmi.selenium.selenese.subcommand.ISubCommand;
import jp.vmi.selenium.selenese.utils.SeleniumUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class BuiltInCommand
extends AbstractCommand {
    private static final String[] NO_UPDATE_SCREEN = new String[]{"createCookie", "deleteCookie", "deleteAllVisibleCookies"};
    private final ISubCommand<?> subCommand;
    private final boolean andWait;
    private final boolean mayUpdateScreen;

    BuiltInCommand(int index, String name, String[] args, ISubCommand<?> subCommand, boolean andWait) {
        super(index, name, args, subCommand.getArgumentTypes());
        this.subCommand = subCommand;
        this.andWait = andWait;
        this.mayUpdateScreen = !ArrayUtils.contains((Object[])NO_UPDATE_SCREEN, (Object)subCommand.getName());
    }

    @Override
    public boolean mayUpdateScreen() {
        return this.mayUpdateScreen;
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        String resultString = SeleniumUtils.convertToString(this.subCommand.execute(context, curArgs));
        if (this.andWait) {
            int timeout = context.getTimeout();
            WaitForPageToLoad.execute(context, timeout);
        }
        return StringUtils.isNotEmpty((CharSequence)resultString) ? new Success(resultString) : Success.SUCCESS;
    }
}

