/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.rollup.IRollupRule;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.command.CommandList;
import jp.vmi.selenium.selenese.result.CommandResultList;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import org.apache.commons.lang3.StringEscapeUtils;

public class Rollup
extends AbstractCommand {
    private static final int ARG_ROLLUP_NAME = 0;
    private static final int ARG_KWARGS = 1;
    private static final Pattern RE_KW_ARGS = Pattern.compile("\\G(\\w+)\\s*=\\s*(?:\"((?:\\\\.|[^\\\"])*)\"|'((?:\\\\.|[^\\'])*)'|(.*?))(?:\\s*,\\s*|\\z)");
    private static final int MG_NAME = 1;
    private static final int MG_DOUBLE_QUOTE = 2;
    private static final int MG_SINGLE_QUOTE = 3;
    private static final int MG_NO_QUOTE = 4;

    Rollup(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.VALUE, ArgumentType.VALUE);
    }

    private Map<String, String> parseKwArgs(String kwArgs) {
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher matcher = RE_KW_ARGS.matcher(kwArgs.trim());
        while (matcher.find()) {
            String name = matcher.group(1);
            String value = matcher.group(2);
            if (value == null) {
                value = matcher.group(3);
            }
            value = value == null ? matcher.group(4) : StringEscapeUtils.unescapeEcmaScript((String)value);
            map.put(name, value);
        }
        return map;
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        String rollupName = curArgs[0];
        String kwArgs = curArgs[1].trim();
        Map<String, String> kwArgsMap = this.parseKwArgs(kwArgs);
        IRollupRule rollupRule = context.getRollupRules().get(rollupName);
        if (rollupRule == null) {
            return new Error("No such rollup rule: " + rollupName);
        }
        CommandList commandList = rollupRule.getExpandedCommands(context, kwArgsMap);
        Result result = commandList.execute(context, new CommandResultList());
        return result == Success.SUCCESS ? new Success("Success: " + rollupRule.getName()) : result;
    }
}

