/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.bridge.SLF4JBridgeHandler;

public final class LoggerUtils {
    private static final Pattern META_CHAR_RE = Pattern.compile("[\u0000-\u001f\u0080\\\\\"]");

    private LoggerUtils() {
    }

    public static void initLogger() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    public static StringBuilder quote(StringBuilder buffer, String str) {
        buffer.append('\"');
        Matcher matcher = META_CHAR_RE.matcher(str);
        int start = 0;
        while (matcher.find(start)) {
            int end = matcher.start();
            if (start < end) {
                buffer.append(str.substring(start, end));
            }
            buffer.append('\\');
            char ch = matcher.group().charAt(0);
            switch (ch) {
                case '\"': 
                case '\\': {
                    buffer.append(ch);
                    break;
                }
                case '\t': {
                    buffer.append('t');
                    break;
                }
                case '\r': {
                    buffer.append('r');
                    break;
                }
                case '\n': {
                    buffer.append('n');
                    break;
                }
                default: {
                    buffer.append(String.format("x%02X", Character.valueOf(ch)));
                }
            }
            start = matcher.end();
        }
        buffer.append(str.substring(start));
        return buffer.append('\"');
    }

    public static String quote(String str) {
        return LoggerUtils.quote(new StringBuilder(str.length() + 8), str).toString();
    }

    public static String[] quote(String[] strs) {
        int len = strs.length;
        String[] result = new String[len];
        for (int i = 0; i < len; ++i) {
            result[i] = LoggerUtils.quote(strs[i]);
        }
        return result;
    }
}

