/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

public class Wait {
    private static final long DEFAULT_INTERVAL = 200L;
    public static final Wait defaultInterval = new Wait(200L);
    private final long interval;

    public static void sleep(long millis) throws RuntimeException {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Wait(long interval) {
        this.interval = interval;
    }

    public boolean wait(long startTime, long timeout, StopCondition stopCondition) {
        if (stopCondition.isSatisfied()) {
            return true;
        }
        do {
            long now;
            long d;
            if ((d = timeout - ((now = System.currentTimeMillis()) - startTime)) <= 0L) {
                return false;
            }
            if (d > this.interval) {
                d = this.interval;
            }
            Wait.sleep(d);
        } while (!stopCondition.isSatisfied());
        return true;
    }

    public static interface StopCondition {
        public boolean isSatisfied();
    }
}

