/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import com.google.common.io.Files;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import jp.vmi.selenium.selenese.utils.PathUtils;
import jp.vmi.selenium.webdriver.CustomChromeDriverService;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ChromeDriverFactory
extends WebDriverFactory {
    public static void setDriverSpecificCapabilities(DesiredCapabilities caps, DriverOptions driverOptions) {
        String experimentalOptions;
        ChromeOptions options = new ChromeOptions();
        if (driverOptions.has(DriverOptions.DriverOption.PROXY)) {
            options.addArguments(new String[]{"--proxy-server=http://" + driverOptions.get(DriverOptions.DriverOption.PROXY)});
        }
        if (driverOptions.has(DriverOptions.DriverOption.CLI_ARGS)) {
            options.addArguments(driverOptions.getCliArgs());
        }
        if (driverOptions.has(DriverOptions.DriverOption.CHROME_EXTENSION)) {
            options.addExtensions(driverOptions.getChromeExtensions());
        }
        if ((experimentalOptions = driverOptions.get(DriverOptions.DriverOption.CHROME_EXPERIMENTAL_OPTIONS)) != null) {
            String json = "{}";
            try {
                json = Files.toString((File)new File(experimentalOptions), (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Map jsonObject = (Map)new Gson().fromJson(json, Map.class);
            for (Map.Entry entry : jsonObject.entrySet()) {
                options.setExperimentalOption((String)entry.getKey(), entry.getValue());
            }
        }
        caps.setCapability("chromeOptions", (Object)options);
        caps.merge((Capabilities)driverOptions.getCapabilities());
    }

    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        DesiredCapabilities caps = DesiredCapabilities.chrome();
        if (driverOptions.has(DriverOptions.DriverOption.CHROMEDRIVER)) {
            String executable = PathUtils.normalize(driverOptions.get(DriverOptions.DriverOption.CHROMEDRIVER));
            if (!new File(executable).canExecute()) {
                throw new IllegalArgumentException("Missing ChromeDriver: " + executable);
            }
            System.setProperty("webdriver.chrome.driver", executable);
        }
        ChromeDriverService service = CustomChromeDriverService.createService(driverOptions.getEnvVars());
        ChromeDriverFactory.setDriverSpecificCapabilities(caps, driverOptions);
        ChromeDriver driver = new ChromeDriver(service, (Capabilities)caps);
        this.setInitialWindowSize((WebDriver)driver, driverOptions);
        return driver;
    }
}

