/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class HtmlUnitDriverFactory
extends WebDriverFactory {
    private static final String HTML_UNIT_DRIVER = "org.openqa.selenium.htmlunit.HtmlUnitDriver";

    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        DesiredCapabilities caps = this.setupProxy(DesiredCapabilities.htmlUnit(), driverOptions);
        caps.setJavascriptEnabled(true);
        caps.merge((Capabilities)driverOptions.getCapabilities());
        try {
            WebDriver driver = (WebDriver)Class.forName(HTML_UNIT_DRIVER).getConstructor(Capabilities.class).newInstance(caps);
            this.setInitialWindowSize(driver, driverOptions);
            return driver;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Dimension getDefaultWindowSize(WebDriver driver) {
        return new Dimension(1024, 768);
    }
}

