/*
 * Decompiled with CFR 0.152.
 */
package mockit.external.hamcrest;

import java.lang.reflect.Method;
import mockit.external.hamcrest.BaseMatcher;
import mockit.external.hamcrest.Description;
import mockit.internal.util.Utilities;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsSame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HamcrestAdapter<T>
extends BaseMatcher<T> {
    private final Matcher<T> hamcrestMatcher;

    public static <T> HamcrestAdapter<T> create(final Object matcher) {
        Object hamcrestMatcher = matcher instanceof Matcher ? (Matcher)matcher : new org.hamcrest.BaseMatcher<T>(){
            Method handler;

            public boolean matches(Object value) {
                Boolean result;
                if (this.handler == null) {
                    this.handler = Utilities.findNonPrivateHandlerMethod(matcher);
                }
                return (result = (Boolean)Utilities.invoke(matcher, this.handler, value)) == null || result != false;
            }

            public void describeTo(org.hamcrest.Description description) {
            }
        };
        return new HamcrestAdapter<T>(hamcrestMatcher);
    }

    private HamcrestAdapter(Matcher<T> matcher) {
        this.hamcrestMatcher = matcher;
    }

    @Override
    public boolean matches(Object item) {
        return this.hamcrestMatcher.matches(item);
    }

    @Override
    public void describeTo(Description description) {
        StringDescription strDescription = new StringDescription();
        this.hamcrestMatcher.describeTo((org.hamcrest.Description)strDescription);
        description.appendText(strDescription.toString());
    }

    public Object getInnerValue() {
        Object innermostMatcher = this.getInnermostMatcher();
        return this.getArgumentValueFromMatcherIfAvailable(innermostMatcher);
    }

    private Object getInnermostMatcher() {
        Matcher innerMatcher = this.hamcrestMatcher;
        while (innerMatcher instanceof Is || innerMatcher instanceof IsNot) {
            innerMatcher = Utilities.getField(innerMatcher.getClass(), Matcher.class, innerMatcher);
        }
        return innerMatcher;
    }

    private Object getArgumentValueFromMatcherIfAvailable(Object argMatcher) {
        if (argMatcher instanceof IsEqual || argMatcher instanceof IsSame || "org.hamcrest.number.OrderingComparison".equals(argMatcher.getClass().getName())) {
            return Utilities.getField(argMatcher.getClass(), Object.class, argMatcher);
        }
        return null;
    }
}

