/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MockingBridge
implements InvocationHandler {
    public static final int RECORD_OR_REPLAY = 1;
    public static final int CALL_CONSTRUCTOR_MOCK = 2;
    public static final int CALL_STATIC_MOCK = 3;
    public static final int CALL_INSTANCE_MOCK = 4;
    public static final int UPDATE_MOCK_STATE = 5;
    public static final int EXIT_REENTRANT_MOCK = 6;
    public static final int FIRST_TARGET_WITH_EXTRA_ARG = 4;
    private static final Object[] EMPTY_ARGS = new Object[0];
    private int targetId;
    private String mockClassInternalName;
    private String mockName;
    private String mockDesc;
    private int mockIndex;
    private Object[] mockArgs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object mocked, Method method, Object[] args) throws Throwable {
        this.mockClassInternalName = (String)args[2];
        if (this.isCallThatParticipatesInClassLoading(mocked)) {
            return Void.class;
        }
        this.targetId = (Integer)args[0];
        int n = this.mockIndex = this.targetId < 4 ? -1 : (Integer)args[5];
        if (this.targetId == 5) {
            return TestRun.updateMockState(this.mockClassInternalName, this.mockIndex);
        }
        if (this.targetId == 6) {
            TestRun.exitReentrantMock(this.mockClassInternalName, this.mockIndex);
            return null;
        }
        this.extractMockMethodAndArguments(args);
        if (this.targetId != 1) {
            return this.callMock(mocked);
        }
        if (TestRun.isInsideNoMockingZone()) {
            return Void.class;
        }
        TestRun.enterNoMockingZone();
        try {
            int mockAccess = (Integer)args[1];
            int executionMode = 0;
            if (this.targetId == 1) {
                executionMode = (Integer)args[5];
            }
            Object object = RecordAndReplayExecution.recordOrReplay(mocked, mockAccess, this.mockClassInternalName, this.mockName + this.mockDesc, executionMode, this.mockArgs);
            return object;
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    private boolean isCallThatParticipatesInClassLoading(Object mocked) {
        Class<?> mockedClass;
        if (mocked != null && ((mockedClass = mocked.getClass()) == File.class || mockedClass == URL.class || Vector.class.isInstance(mocked) || Hashtable.class.isInstance(mocked))) {
            StackTraceElement[] st = new Throwable().getStackTrace();
            for (int i = 3; i < st.length; ++i) {
                StackTraceElement ste = st[i];
                if (!"ClassLoader.java".equals(ste.getFileName()) || !"loadClass".equals(ste.getMethodName())) continue;
                return true;
            }
        }
        return false;
    }

    private void extractMockMethodAndArguments(Object[] args) {
        int i;
        this.mockName = (String)args[3];
        this.mockDesc = (String)args[4];
        int n = i = this.targetId > 1 && this.targetId < 4 ? 5 : 6;
        if (args.length > i) {
            this.mockArgs = new Object[args.length - i];
            System.arraycopy(args, i, this.mockArgs, 0, this.mockArgs.length);
        } else {
            this.mockArgs = EMPTY_ARGS;
        }
    }

    private Object callMock(Object mocked) {
        Class<Object> mockClass;
        String mockClassName;
        Object mock;
        if (this.targetId == 2) {
            String mockClassName2 = this.getMockClassName();
            Class<?>[] paramClasses = Utilities.getParameterTypes(this.mockDesc);
            Utilities.newInstance(mockClassName2, paramClasses, this.mockArgs);
            return null;
        }
        if (this.targetId == 3) {
            mock = mocked;
            mockClassName = this.getMockClassName();
            mockClass = Utilities.loadClass(mockClassName);
        } else {
            assert (this.targetId == 4);
            if (this.mockIndex < 0) {
                mockClassName = this.getMockClassName();
                mock = Utilities.newInstance(mockClassName, new Object[0]);
            } else {
                mock = TestRun.getMock(this.mockIndex);
            }
            mockClass = mock.getClass();
            this.setItFieldIfAny(mockClass, mock, mocked);
        }
        Class<?>[] paramClasses = Utilities.getParameterTypes(this.mockDesc);
        Object result = Utilities.invoke(mockClass, mock, this.mockName, paramClasses, this.mockArgs);
        return result;
    }

    private String getMockClassName() {
        return this.mockClassInternalName.replace('/', '.');
    }

    private void setItFieldIfAny(Class<?> mockClass, Object mock, Object mocked) {
        try {
            Field itField = mockClass.getDeclaredField("it");
            Utilities.setFieldValue(itField, mock, mocked);
        }
        catch (NoSuchFieldException ignore) {
            // empty catch block
        }
    }
}

