/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.startup;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.util.regex.Pattern;
import mockit.internal.startup.JDK6AgentLoader;
import mockit.internal.startup.Startup;

public final class AgentInitialization {
    private static final Pattern JAR_REGEX = Pattern.compile(".*jmockit[-.\\d]*.jar");

    public void initializeAccordingToJDKVersion() {
        String jarFilePath = this.discoverPathToJarFile();
        if (!Startup.jdk6OrLater) {
            if ("1.5".equals(Startup.javaSpecVersion)) {
                throw new IllegalStateException("JMockit has not been initialized. Check that your Java 5 VM has been started with the -javaagent:" + jarFilePath + " command line option.");
            }
            throw new IllegalStateException("JMockit requires a Java 5 VM or later.");
        }
        new JDK6AgentLoader(jarFilePath).loadAgent();
    }

    private String discoverPathToJarFile() {
        String jarFilePath = this.findPathToJarFileFromClasspath();
        if (jarFilePath == null) {
            jarFilePath = this.getPathToJarFileContainingThisClass();
        }
        if (jarFilePath != null) {
            return jarFilePath;
        }
        throw new IllegalStateException("No jar file with name ending in \"jmockit.jar\" or \"jmockit-nnn.jar\" (where \"nnn\" is a version number) found in the classpath");
    }

    private String findPathToJarFileFromClasspath() {
        String[] classPath;
        for (String cpEntry : classPath = System.getProperty("java.class.path").split(File.pathSeparator)) {
            if (!JAR_REGEX.matcher(cpEntry).matches()) continue;
            return cpEntry;
        }
        return null;
    }

    private String getPathToJarFileContainingThisClass() {
        URI jarFileURI;
        CodeSource codeSource = AgentInitialization.class.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            return null;
        }
        try {
            jarFileURI = codeSource.getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return new File(jarFileURI).getPath();
    }
}

