/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.startup;

import java.lang.instrument.ClassFileTransformer;
import mockit.external.asm.AnnotationVisitor;
import mockit.external.asm.Attribute;
import mockit.external.asm.ClassVisitor;
import mockit.external.asm.FieldVisitor;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.commons.EmptyVisitor;
import mockit.internal.RedefinitionEngine;
import mockit.internal.startup.Startup;
import mockit.internal.util.Utilities;

final class ToolLoader
implements ClassVisitor {
    private final String toolClassName;
    private final String toolArgs;
    private boolean loadClassFileTransformer;

    ToolLoader(String toolClassName, String toolArgs) {
        this.toolClassName = toolClassName;
        this.toolArgs = toolArgs;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (interfaces != null && this.containsClassFileTransformer(interfaces)) {
            this.loadClassFileTransformer = true;
        }
    }

    private boolean containsClassFileTransformer(String[] interfaces) {
        for (String anInterface : interfaces) {
            if (!"java/lang/instrument/ClassFileTransformer".equals(anInterface)) continue;
            return true;
        }
        return false;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new EmptyVisitor();
    }

    public void visitSource(String source, String debug) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return null;
    }

    public void visitEnd() {
        if (this.loadClassFileTransformer) {
            this.createAndInstallSpecifiedClassFileTransformer();
        } else {
            this.setUpStartupMock();
        }
    }

    private void createAndInstallSpecifiedClassFileTransformer() {
        Class transformerClass = Utilities.loadClass(this.toolClassName);
        ClassFileTransformer transformer = (ClassFileTransformer)Utilities.newInstance(transformerClass, new Class[]{String.class}, new Object[]{this.toolArgs});
        Startup.instrumentation().addTransformer(transformer);
    }

    private void setUpStartupMock() {
        try {
            Class<?> mockClass = Class.forName(this.toolClassName);
            Object mock = Utilities.newInstance(mockClass);
            new RedefinitionEngine(mock, mockClass, true).setUpStartupMock();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoClassDefFoundError e) {
            System.out.println(e);
        }
    }
}

