/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.io;

import com.mockobjects.ExpectationCounter;
import com.mockobjects.ExpectationSegment;
import com.mockobjects.Verifiable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class MockPrintWriter
extends PrintWriter
implements Verifiable {
    private ExpectationSegment mySegment = new ExpectationSegment("String segment");
    private ExpectationCounter myCloseCalls = new ExpectationCounter("close calls");

    public MockPrintWriter() {
        this(new StringWriter());
    }

    private MockPrintWriter(Writer writer) {
        super(writer);
    }

    public void close() {
        super.close();
        this.myCloseCalls.inc();
    }

    public void setExpectedCloseCalls(int calls) {
        this.myCloseCalls.setExpected(calls);
    }

    public void setExpectedSegment(String aString) {
        this.mySegment.setExpected(aString);
    }

    public void verify() {
        this.mySegment.verify();
        this.myCloseCalls.verify();
    }

    public void write(String s) {
        super.write(s);
        this.mySegment.setActual(s);
    }
}

