/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.sql;

import com.mockobjects.ExpectationCounter;
import com.mockobjects.ExpectationValue;
import com.mockobjects.MockObject;
import com.mockobjects.ReturnObjectList;
import com.mockobjects.sql.MockResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public abstract class CommonMockStatement
extends MockObject
implements Statement {
    protected ExpectationCounter myCloseCalls = new ExpectationCounter("CommonMockStatement.closeCalls");
    protected ExpectationCounter myExecuteCalls = new ExpectationCounter("CommonMockStatement.executeCalls");
    protected ExpectationValue myQueryString = new ExpectationValue("CommonMockStatement.queryString");
    protected ReturnObjectList myResultSets = new ReturnObjectList("result set");
    private int myUpdateCount = 0;
    private SQLException myExecuteException = null;
    private Connection myConnection = null;

    public void setExpectedExecuteCalls(int callCount) {
        this.myExecuteCalls.setExpected(callCount);
    }

    public void setExpectedQueryString(String queryString) {
        this.myQueryString.setExpected((Object)queryString);
    }

    public void setExpectedCloseCalls(int callCount) {
        this.myCloseCalls.setExpected(callCount);
    }

    public void addResultSet(MockResultSet aResultSet) {
        this.myResultSets.addObjectToReturn((Object)aResultSet);
    }

    public void setupConnection(Connection conn) {
        this.myConnection = conn;
    }

    public void setupThrowExceptionOnExecute(SQLException exception) {
        this.myExecuteException = exception;
    }

    public void setupUpdateCount(int updateCount) {
        this.myUpdateCount = updateCount;
    }

    protected void innerExecute() throws SQLException {
        this.myExecuteCalls.inc();
        if (null != this.myExecuteException) {
            throw this.myExecuteException;
        }
    }

    public void close() throws SQLException {
        this.myCloseCalls.inc();
    }

    public boolean execute(String sql) throws SQLException {
        this.notImplemented();
        return true;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.myQueryString.setActual((Object)sql);
        this.innerExecute();
        return (ResultSet)this.myResultSets.nextReturnObject();
    }

    public int executeUpdate(String sql) throws SQLException {
        this.myQueryString.setActual((Object)sql);
        this.innerExecute();
        return this.myUpdateCount;
    }

    public int getMaxFieldSize() throws SQLException {
        this.notImplemented();
        return 0;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.notImplemented();
    }

    public int getMaxRows() throws SQLException {
        this.notImplemented();
        return 0;
    }

    public void setMaxRows(int max) throws SQLException {
        this.notImplemented();
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.notImplemented();
    }

    public int getQueryTimeout() throws SQLException {
        this.notImplemented();
        return 0;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.notImplemented();
    }

    public void cancel() throws SQLException {
        this.notImplemented();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.notImplemented();
        return null;
    }

    public void clearWarnings() throws SQLException {
        this.notImplemented();
    }

    public void setCursorName(String name) throws SQLException {
        this.notImplemented();
    }

    public ResultSet getResultSet() throws SQLException {
        this.notImplemented();
        return null;
    }

    public int getUpdateCount() throws SQLException {
        return this.myUpdateCount;
    }

    public boolean getMoreResults() throws SQLException {
        this.notImplemented();
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.notImplemented();
    }

    public int getFetchDirection() throws SQLException {
        this.notImplemented();
        return 0;
    }

    public void setFetchSize(int rows) throws SQLException {
        this.notImplemented();
    }

    public int getFetchSize() throws SQLException {
        this.notImplemented();
        return 0;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.notImplemented();
        return 0;
    }

    public int getResultSetType() throws SQLException {
        this.notImplemented();
        return 0;
    }

    public void addBatch(String sql) throws SQLException {
        this.notImplemented();
    }

    public void clearBatch() throws SQLException {
        this.notImplemented();
    }

    public int[] executeBatch() throws SQLException {
        this.notImplemented();
        return null;
    }

    public Connection getConnection() throws SQLException {
        return this.myConnection;
    }
}

