/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.servlet;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jawr.web.context.ThreadLocalJawrContext;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.servlet.JawrBinaryResourceRequestHandler;
import net.jawr.web.servlet.JawrRequestHandler;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.util.UrlPathHelper;

public class JawrSpringController
implements Controller,
ServletContextAware,
InitializingBean,
ServletContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JawrSpringController.class);
    private JawrRequestHandler requestHandler;
    private Map<String, Object> initParams;
    private String type;
    private String configPropertiesSourceClass;
    private String mapping;
    private String controllerMapping;
    private final UrlPathHelper helper = new UrlPathHelper();
    private Properties configuration;
    private String configLocation;
    private ServletContext context;

    public void setServletContext(ServletContext context) {
        this.context = context;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getInitParams() {
        return this.initParams;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setConfigPropertiesSourceClass(String configPropertiesSourceClass) {
        this.configPropertiesSourceClass = configPropertiesSourceClass;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    public void setConfiguration(Properties configuration) {
        this.configuration = configuration;
    }

    public void setControllerMapping(String controllerMapping) {
        this.controllerMapping = controllerMapping.endsWith("/") ? controllerMapping.substring(0, controllerMapping.length() - 1) : controllerMapping;
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String requestedPath;
        String string = requestedPath = StringUtils.isEmpty((String)this.mapping) ? this.helper.getPathWithinApplication(request) : this.helper.getPathWithinServletMapping(request);
        if (StringUtils.isNotEmpty((String)this.controllerMapping)) {
            requestedPath = requestedPath.substring(this.controllerMapping.length());
        }
        this.requestHandler.processRequest(requestedPath, request, response);
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        this.initParams = new HashMap<String, Object>(3);
        this.initParams.put("type", this.type);
        this.initParams.put("configPropertiesSourceClass", this.configPropertiesSourceClass);
        this.initParams.put("configLocation", this.configLocation);
        if (null == this.configuration && null == this.configLocation && null == this.configPropertiesSourceClass) {
            throw new ServletException("Neither configuration nor configLocation nor configPropertiesSourceClass init params were set. You must set at least the configuration or the configLocation param. Please check your web.xml file");
        }
        String fullMapping = "";
        if (StringUtils.isNotEmpty((String)this.mapping)) {
            fullMapping = this.mapping;
        }
        if (StringUtils.isNotEmpty((String)this.controllerMapping)) {
            fullMapping = PathNormalizer.joinPaths((String)fullMapping, (String)this.controllerMapping);
        }
        this.initParams.put("mapping", fullMapping);
        if (this.mapping != null) {
            this.initParams.put("springServletMapping", PathNormalizer.asDirPath((String)this.mapping));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initializing Jawr Controller's JawrRequestHandler");
        }
        this.requestHandler = "binary".equals(this.type) ? new JawrBinaryResourceRequestHandler(this.context, this.initParams, this.configuration) : new JawrRequestHandler(this.context, this.initParams, this.configuration);
    }

    public void contextInitialized(ServletContextEvent sce) {
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ThreadLocalJawrContext.reset();
    }
}

