/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.joda;

import net.objectlab.kit.datecalc.common.AbstractKitCalculatorsFactory;
import net.objectlab.kit.datecalc.common.IMMDateCalculator;
import net.objectlab.kit.datecalc.common.PeriodCountCalculator;
import net.objectlab.kit.datecalc.joda.LocalDateBackwardHandler;
import net.objectlab.kit.datecalc.joda.LocalDateCalculator;
import net.objectlab.kit.datecalc.joda.LocalDateForwardHandler;
import net.objectlab.kit.datecalc.joda.LocalDateForwardUnlessNegativeHandler;
import net.objectlab.kit.datecalc.joda.LocalDateIMMDateCalculator;
import net.objectlab.kit.datecalc.joda.LocalDateModifiedFollowingHandler;
import net.objectlab.kit.datecalc.joda.LocalDateModifiedPrecedingHandler;
import net.objectlab.kit.datecalc.joda.LocalDatePeriodCountCalculator;
import org.joda.time.LocalDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDateKitCalculatorsFactory
extends AbstractKitCalculatorsFactory<LocalDate> {
    private static final LocalDateKitCalculatorsFactory DEFAULT = new LocalDateKitCalculatorsFactory();
    private static final PeriodCountCalculator<LocalDate> PCC = new LocalDatePeriodCountCalculator();
    private static final IMMDateCalculator<LocalDate> IMMDC = new LocalDateIMMDateCalculator();

    public static LocalDateKitCalculatorsFactory getDefaultInstance() {
        return DEFAULT;
    }

    public LocalDateCalculator getDateCalculator(String name, String holidayHandlerType) {
        LocalDateCalculator cal = new LocalDateCalculator();
        cal.setName(name);
        this.setHolidays(name, cal);
        if ("forward".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new LocalDateForwardHandler());
        } else if ("backward".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new LocalDateBackwardHandler());
        } else if ("modifiedFollowing".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new LocalDateModifiedFollowingHandler());
        } else if ("modifiedPreceding".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new LocalDateModifiedPrecedingHandler());
        } else if ("forwardUnlessMovingBack".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new LocalDateForwardUnlessNegativeHandler());
        } else if (holidayHandlerType != null) {
            throw new IllegalArgumentException("Unsupported HolidayHandler: " + holidayHandlerType);
        }
        return cal;
    }

    @Override
    public PeriodCountCalculator<LocalDate> getPeriodCountCalculator() {
        return PCC;
    }

    @Override
    public IMMDateCalculator<LocalDate> getIMMDateCalculator() {
        return IMMDC;
    }
}

