/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.joda;

import net.objectlab.kit.datecalc.common.PeriodCountBasis;
import net.objectlab.kit.datecalc.common.PeriodCountCalculator;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePartial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDatePeriodCountCalculator
implements PeriodCountCalculator<LocalDate> {
    @Override
    public int dayDiff(LocalDate start, LocalDate end, PeriodCountBasis basis) {
        int diff = 0;
        switch (basis) {
            case CONV_30_360: {
                diff = this.diffConv30v360(start, end);
                break;
            }
            case CONV_360E_ISDA: {
                diff = this.diff360EIsda(start, end);
                break;
            }
            case CONV_360E_ISMA: {
                diff = this.diff360EIsma(start, end);
                break;
            }
            default: {
                Period p = new Period((ReadablePartial)start, (ReadablePartial)end, PeriodType.days());
                diff = p.getDays();
            }
        }
        return diff;
    }

    private int diff360EIsma(LocalDate start, LocalDate end) {
        int dayStart = start.getDayOfMonth();
        int dayEnd = end.getDayOfMonth();
        if (dayEnd == 31) {
            dayEnd = 30;
        }
        if (dayStart == 31) {
            dayStart = 30;
        }
        return (end.getYear() - start.getYear()) * 360 + (end.getMonthOfYear() - start.getMonthOfYear()) * 30 + dayEnd - dayStart;
    }

    private int diff360EIsda(LocalDate start, LocalDate end) {
        int dayStart = start.getDayOfMonth();
        int dayEnd = end.getDayOfMonth();
        int monthStart = start.getMonthOfYear();
        if (monthStart == 2 && start.monthOfYear().getMaximumValue() == dayStart || dayEnd == 31) {
            dayEnd = 30;
        }
        if (dayStart == 31) {
            dayStart = 30;
        }
        return (end.getYear() - start.getYear()) * 360 + (end.getMonthOfYear() - start.getMonthOfYear()) * 30 + dayEnd - dayStart;
    }

    private int diffConv30v360(LocalDate start, LocalDate end) {
        int dayStart = start.getDayOfMonth();
        int dayEnd = end.getDayOfMonth();
        if (dayEnd == 31 && dayStart >= 30) {
            dayEnd = 30;
        }
        if (dayStart == 31) {
            dayStart = 30;
        }
        return (end.getYear() - start.getYear()) * 360 + (end.getMonthOfYear() - start.getMonthOfYear()) * 30 + dayEnd - dayStart;
    }

    @Override
    public double monthDiff(LocalDate start, LocalDate end, PeriodCountBasis basis) {
        return this.yearDiff(start, end, basis) * 12.0;
    }

    @Override
    public double yearDiff(LocalDate start, LocalDate end, PeriodCountBasis basis) {
        double diff = 0.0;
        switch (basis) {
            case ACT_ACT: {
                int startYear = start.getYear();
                int endYear = end.getYear();
                if (startYear == endYear) break;
                LocalDate endOfStartYear = start.dayOfYear().withMaximumValue();
                LocalDate startOfEndYear = end.withDayOfYear(1);
                int diff1 = new Period((ReadablePartial)start, (ReadablePartial)endOfStartYear, PeriodType.days()).getDays();
                int diff2 = new Period((ReadablePartial)startOfEndYear, (ReadablePartial)end, PeriodType.days()).getDays();
                diff = ((double)diff1 + 1.0) / (double)start.dayOfYear().getMaximumValue() + ((double)(endYear - startYear) - 1.0) + (double)diff2 / (double)end.dayOfYear().getMaximumValue();
                break;
            }
            case CONV_30_360: 
            case CONV_360E_ISDA: 
            case CONV_360E_ISMA: 
            case ACT_360: {
                diff = (double)this.dayDiff(start, end, basis) / 360.0;
                break;
            }
            case ACT_365: {
                diff = (double)this.dayDiff(start, end, basis) / 365.0;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Sorry ACT_UST is not supported");
            }
        }
        return diff;
    }
}

