/*
 * Decompiled with CFR 0.152.
 */
package org.openas2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.BaseSession;
import org.openas2.Component;
import org.openas2.OpenAS2Exception;
import org.openas2.cert.CertificateFactory;
import org.openas2.cmd.CommandManager;
import org.openas2.cmd.CommandRegistry;
import org.openas2.cmd.processor.BaseCommandProcessor;
import org.openas2.lib.xml.PropertyReplacementFilter;
import org.openas2.logging.LogManager;
import org.openas2.logging.Logger;
import org.openas2.partner.PartnershipFactory;
import org.openas2.processor.Processor;
import org.openas2.processor.ProcessorModule;
import org.openas2.schedule.SchedulerComponent;
import org.openas2.util.Properties;
import org.openas2.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLSession
extends BaseSession {
    private static final String EL_PROPERTIES = "properties";
    private static final String EL_CERTIFICATES = "certificates";
    private static final String EL_CMDPROCESSOR = "commandProcessors";
    private static final String EL_PROCESSOR = "processor";
    private static final String EL_PARTNERSHIPS = "partnerships";
    private static final String EL_COMMANDS = "commands";
    private static final String EL_LOGGERS = "loggers";
    private CommandRegistry commandRegistry;
    private CommandManager cmdManager = new CommandManager();
    private static final String MANIFEST_VENDOR_ID_ATTRIB = "Implementation-Vendor-Id";
    private static final String MANIFEST_VERSION_ATTRIB = "Implementation-Version";
    private static final String MANIFEST_TITLE_ATTRIB = "Implementation-Title";
    private static final String VENDOR_ID = "net.sf.openas2";
    private static final String PROJECT_NAME = "OpenAS2 Server";
    private Attributes manifestAttributes = null;
    private String VERSION;
    private String TITLE;
    private static final Log LOGGER = LogFactory.getLog((String)XMLSession.class.getSimpleName());

    public XMLSession(String configAbsPath) throws Exception {
        File configXml = new File(configAbsPath);
        File configDir = configXml.getParentFile();
        this.getManifestAttributes();
        FileInputStream configAsStream = new FileInputStream(configXml);
        this.setBaseDirectory(configDir.getAbsolutePath());
        this.load(configAsStream);
        this.addSchedulerComponent();
    }

    private void addSchedulerComponent() throws OpenAS2Exception {
        SchedulerComponent comp = new SchedulerComponent();
        this.setComponent("scheduler", comp);
        comp.init(this, Collections.emptyMap());
    }

    protected void load(InputStream in) throws Exception {
        Document document = XMLUtil.parseXML(in, new PropertyReplacementFilter());
        Element root = document.getDocumentElement();
        NodeList rootNodes = root.getChildNodes();
        LOGGER.info((Object)"Loading configuration...");
        for (int i = 0; i < rootNodes.getLength(); ++i) {
            Node rootNode = rootNodes.item(i);
            String nodeName = rootNode.getNodeName();
            if (nodeName.equals(EL_PROPERTIES)) {
                this.loadProperties(rootNode);
                continue;
            }
            if (nodeName.equals(EL_CERTIFICATES)) {
                this.loadCertificates(rootNode);
                continue;
            }
            if (nodeName.equals(EL_PROCESSOR)) {
                this.loadProcessor(rootNode);
                continue;
            }
            if (nodeName.equals(EL_CMDPROCESSOR)) {
                this.loadCommandProcessors(rootNode);
                continue;
            }
            if (nodeName.equals(EL_PARTNERSHIPS)) {
                this.loadPartnerships(rootNode);
                continue;
            }
            if (nodeName.equals(EL_COMMANDS)) {
                this.loadCommands(rootNode);
                continue;
            }
            if (nodeName.equals(EL_LOGGERS)) {
                this.loadLoggers(rootNode);
                continue;
            }
            if (nodeName.equals("#text") || nodeName.equals("#comment")) continue;
            throw new OpenAS2Exception("Undefined tag: " + nodeName);
        }
        this.cmdManager.registerCommands(this.commandRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(Node propNode) {
        LOGGER.info((Object)"Loading properties...");
        Map<String, String> properties = XMLUtil.mapAttributes(propNode, false);
        properties.put("app.title", this.getAppTitle());
        properties.put("app.version", this.getAppVersion());
        Properties.setProperties(properties);
        String appPropsFile = System.getProperty("openas2.properties.file");
        if (appPropsFile != null && appPropsFile.length() > 1) {
            java.util.Properties appProps = new java.util.Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(appPropsFile);
                appProps.load(fis);
                Enumeration<Object> enuKeys = appProps.keys();
                while (enuKeys.hasMoreElements()) {
                    String key = (String)enuKeys.nextElement();
                    Properties.setProperty(key, appProps.getProperty(key));
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.warn((Object)("Custom properties file specified but cannot be located:" + appPropsFile));
            }
            catch (IOException e) {
                LOGGER.warn((Object)("Custom properties file load failed:" + appPropsFile), (Throwable)e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        LOGGER.warn((Object)"Failed to close properties fiel input stream.", (Throwable)e);
                    }
                }
            }
        }
    }

    private void loadCertificates(Node rootNode) throws OpenAS2Exception {
        CertificateFactory certFx = (CertificateFactory)XMLUtil.getComponent(rootNode, this);
        this.setComponent("certificatefactory", certFx);
    }

    private void loadCommands(Node rootNode) throws OpenAS2Exception {
        Component component = XMLUtil.getComponent(rootNode, this);
        this.commandRegistry = (CommandRegistry)component;
    }

    private void loadLoggers(Node rootNode) throws OpenAS2Exception {
        LOGGER.info((Object)"Loading log manager(s)...");
        LogManager manager = LogManager.getLogManager();
        if (!LogManager.isRegisteredWithApache()) {
            throw new OpenAS2Exception("the OpenAS2 loggers' log manager must be registered with the jvm argument -Dorg.apache.commons.logging.Log=org.openas2.logging.Log");
        }
        NodeList loggers = rootNode.getChildNodes();
        for (int i = 0; i < loggers.getLength(); ++i) {
            Node logger = loggers.item(i);
            if (!logger.getNodeName().equals("logger")) continue;
            if ("true".equalsIgnoreCase(XMLUtil.getNodeAttributeValue(logger, "enabled", true))) {
                this.loadLogger(manager, logger);
                continue;
            }
            LOGGER.info((Object)("Logger is disabled ... ignoring: " + XMLUtil.getNodeAttributeValue(logger, "classname", false)));
        }
    }

    private void loadLogger(LogManager manager, Node loggerNode) throws OpenAS2Exception {
        Logger logger = (Logger)XMLUtil.getComponent(loggerNode, this);
        manager.addLogger(logger);
    }

    private void loadCommandProcessors(Node rootNode) throws OpenAS2Exception {
        LOGGER.info((Object)"Loading command processor(s)...");
        NodeList cmdProcessor = rootNode.getChildNodes();
        for (int i = 0; i < cmdProcessor.getLength(); ++i) {
            Node processor = cmdProcessor.item(i);
            if (!processor.getNodeName().equals("commandProcessor")) continue;
            if ("true".equalsIgnoreCase(XMLUtil.getNodeAttributeValue(processor, "enabled", true))) {
                this.loadCommandProcessor(this.cmdManager, processor);
                continue;
            }
            LOGGER.info((Object)("Command processor is disabled ... ignoring: " + XMLUtil.getNodeAttributeValue(processor, "classname", false)));
        }
    }

    private void loadCommandProcessor(CommandManager manager, Node cmdPrcessorNode) throws OpenAS2Exception {
        BaseCommandProcessor cmdProcesor = (BaseCommandProcessor)XMLUtil.getComponent(cmdPrcessorNode, this);
        manager.addProcessor(cmdProcesor);
        this.setComponent(cmdProcesor.getName(), cmdProcesor);
    }

    private void loadPartnerships(Node rootNode) throws OpenAS2Exception {
        LOGGER.info((Object)"Loading partnerships...");
        PartnershipFactory partnerFx = (PartnershipFactory)XMLUtil.getComponent(rootNode, this);
        this.setComponent("partnershipfactory", partnerFx);
    }

    private void loadProcessor(Node rootNode) throws OpenAS2Exception {
        Processor proc = (Processor)XMLUtil.getComponent(rootNode, this);
        this.setComponent(EL_PROCESSOR, proc);
        LOGGER.info((Object)"Loading processor modules...");
        NodeList modules = rootNode.getChildNodes();
        for (int i = 0; i < modules.getLength(); ++i) {
            Node module = modules.item(i);
            if (!module.getNodeName().equals("module")) continue;
            String enabledFlag = XMLUtil.getNodeAttributeValue(module, "enabled", true);
            if (enabledFlag == null || "true".equalsIgnoreCase(enabledFlag)) {
                this.loadProcessorModule(proc, module);
                continue;
            }
            try {
                LOGGER.info((Object)("Module is disabled ... ignoring: " + XMLUtil.toString(module, true)));
                continue;
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadProcessorModule(Processor proc, Node moduleNode) throws OpenAS2Exception {
        ProcessorModule procmod = (ProcessorModule)XMLUtil.getComponent(moduleNode, this);
        proc.getModules().add(procmod);
    }

    private void getManifestAttributes() throws OpenAS2Exception {
        URL openAS2Manifest = null;
        try {
            Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resEnum.hasMoreElements()) {
                try {
                    String project;
                    URL url = resEnum.nextElement();
                    InputStream is = url.openStream();
                    if (is == null) continue;
                    Manifest manifest = new Manifest(is);
                    Attributes mainAttribs = manifest.getMainAttributes();
                    is.close();
                    String vendor = mainAttribs.getValue(MANIFEST_VENDOR_ID_ATTRIB);
                    if (vendor == null || !VENDOR_ID.equals(vendor) || (project = mainAttribs.getValue(MANIFEST_TITLE_ATTRIB)) == null || !PROJECT_NAME.equals(project)) continue;
                    if (openAS2Manifest != null) {
                        throw new OpenAS2Exception("|Duplicate manifests detected: " + openAS2Manifest.getPath() + " ::: " + url.getPath());
                    }
                    openAS2Manifest = url;
                    this.manifestAttributes = mainAttribs;
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (openAS2Manifest == null) {
            LOGGER.warn((Object)"Failed to find a MANIFEST.MF with the desired vendor and project name.");
        } else {
            LOGGER.info((Object)("Using MANIFEST " + openAS2Manifest.getPath()));
        }
    }

    @Nullable
    private String getManifestAttribValue(@Nonnull String attrib) throws OpenAS2Exception {
        if (this.manifestAttributes != null) {
            return this.manifestAttributes.getValue(attrib);
        }
        return "NO MANIFEST";
    }

    @Override
    public String getAppVersion() {
        if (this.VERSION == null) {
            try {
                this.VERSION = this.getManifestAttribValue(MANIFEST_VERSION_ATTRIB);
            }
            catch (OpenAS2Exception e) {
                LOGGER.warn((Object)e.getMessage());
            }
        }
        return this.VERSION;
    }

    @Override
    public String getAppTitle() {
        if (this.TITLE == null) {
            try {
                this.TITLE = this.getManifestAttribValue(MANIFEST_TITLE_ATTRIB) + " v" + this.getAppVersion();
            }
            catch (OpenAS2Exception e) {
                LOGGER.warn((Object)e.getMessage());
            }
        }
        return this.TITLE;
    }
}

