/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.app;

import java.io.File;
import javax.annotation.Nonnull;
import javax.crypto.Cipher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.XMLSession;

public class OpenAS2Server {
    private static final Log LOGGER = LogFactory.getLog((String)OpenAS2Server.class.getSimpleName());
    @Nonnull
    private final Session session;
    private boolean isStarted = false;

    public boolean isStarted() {
        return this.isStarted;
    }

    public void setStarted(boolean isStarted) {
        this.isStarted = isStarted;
    }

    public Session getSession() {
        return this.session;
    }

    public OpenAS2Server(@Nonnull Session session) {
        this.session = session;
    }

    public static void main(String[] args) throws Exception {
        new Builder().registerShutdownHook().run(args);
    }

    protected void start() throws Exception {
        LOGGER.info((Object)("Starting " + this.session.getAppTitle() + "..."));
        this.session.start();
        LOGGER.info((Object)(this.session.getAppTitle() + " started."));
        this.setStarted(true);
    }

    public void shutdown() {
        try {
            this.session.getProcessor().stopActiveModules();
        }
        catch (OpenAS2Exception same) {
            same.terminate();
        }
        LOGGER.info((Object)"OpenAS2 has shut down\r\n");
    }

    public static class Builder {
        private boolean registerShutdownHook;

        @Nonnull
        private static File findConfig(@Nonnull String[] runArgs) throws Exception {
            File cfg;
            String configFile;
            LOGGER.info((Object)"Retrieving config file...");
            String string = configFile = runArgs.length > 0 ? runArgs[0] : System.getProperty("openas2.config.file");
            if (configFile == null || configFile.length() < 1) {
                configFile = System.getProperty("user.dir") + "/../config/config.xml";
            }
            if (!(cfg = new File(configFile)).exists()) {
                LOGGER.error((Object)("No config file found: " + configFile));
                LOGGER.error((Object)"Pass as the first paramter on the command line or set the system property \"openas2.config.file\" to identify the configuration file to start OpenAS2");
                throw new Exception("Missing configuration file");
            }
            return cfg;
        }

        public OpenAS2Server run(String ... args) throws Exception {
            if (Cipher.getMaxAllowedKeyLength("md5") <= 128) {
                LOGGER.fatal((Object)"OpenAS2 needs `Java Cryptography Extension`\u00a0(JCE) Unlimited Strength Jurisdiction Policy Files!\nPlease verify it is installed in your Java installation. You can download it from Oracle Web site.");
                System.exit(1);
            }
            XMLSession session = new XMLSession(Builder.findConfig(args).getAbsolutePath());
            OpenAS2Server server = new OpenAS2Server(session);
            this.registerShutdownHookIfNeeded(server);
            server.start();
            return server;
        }

        private void registerShutdownHookIfNeeded(final OpenAS2Server server) {
            if (this.registerShutdownHook) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        server.shutdown();
                    }
                });
                LOGGER.info((Object)"Shutdown hook registered.");
            }
        }

        public Builder registerShutdownHook() {
            this.registerShutdownHook = true;
            return this;
        }
    }
}

