/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.cmd.processor;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Application;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpContainer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.cmd.Command;
import org.openas2.cmd.CommandResult;
import org.openas2.cmd.processor.BaseCommandProcessor;
import org.openas2.cmd.processor.restapi.ApiResource;
import org.openas2.cmd.processor.restapi.AuthenticationRequestFilter;
import org.openas2.cmd.processor.restapi.CORSFilter;
import org.openas2.cmd.processor.restapi.LoggerRequestFilter;

public class RestCommandProcessor
extends BaseCommandProcessor {
    private final Log logger = LogFactory.getLog((String)RestCommandProcessor.class.getSimpleName());
    public static final String BASE_URI = "http://localhost:8080/";
    private HttpServer server;

    @Override
    public void processCommand() throws Exception {
    }

    public CommandResult feedCommand(String commandText, List<String> params) throws Exception {
        CommandResult result = null;
        if (commandText != null && commandText.length() > 0) {
            String commandName = commandText.toLowerCase();
            if (commandName.equals("exit")) {
                this.terminate();
            } else {
                Command cmd = this.getCommand(commandName);
                if (cmd != null) {
                    result = cmd.execute(params.toArray());
                } else {
                    result = new CommandResult("Error: command not found");
                    List<Command> l = this.getCommands();
                    for (int i = 0; i < l.size(); ++i) {
                        cmd = l.get(i);
                        result.getResults().add(cmd.getName());
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void destroy() throws Exception {
        try {
            super.destroy();
            this.server.shutdown();
            this.logger.info((Object)(this.getName() + " destroyed..."));
        }
        catch (Exception e) {
            this.logger.error((Object)"failed to cleanup RestAPI command processor", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void init(Session session, Map<String, String> parameters) throws OpenAS2Exception {
        try {
            super.init(session, parameters);
            this.logger.info((Object)(this.getName() + " initialized..."));
            String userId = parameters.getOrDefault("userid", "userid");
            String password = parameters.getOrDefault("password", "pWd");
            ResourceConfig rc = new ResourceConfig();
            rc.register((Object)new LoggerRequestFilter(this.logger)).register((Object)new AuthenticationRequestFilter(userId, password)).register((Object)new ApiResource(this)).register((Object)new CORSFilter()).register((Object)new JacksonFeature());
            URI baseUri = URI.create(parameters.getOrDefault("baseuri", BASE_URI));
            this.logger.info((Object)"Creating and starting a new instance of grizzly http server");
            this.logger.info((Object)("Exposing the Jersey application at " + baseUri));
            if (baseUri.getScheme().equalsIgnoreCase("https")) {
                SSLContextConfigurator sslCon = new SSLContextConfigurator();
                String keystore = parameters.get("ssl_keystore");
                if (null == keystore) {
                    throw new RuntimeException("Missing SSL Keystore parameter in the configuration. You cannot use SSL without a Certificate");
                }
                sslCon.setKeyStoreFile(keystore);
                sslCon.setKeyStorePass(parameters.getOrDefault("ssl_keystore_password", ""));
                sslCon.setSecurityProtocol(parameters.getOrDefault("ssl_protocol", "TLS"));
                GrizzlyHttpContainer container = (GrizzlyHttpContainer)ContainerFactory.createContainer(GrizzlyHttpContainer.class, (Application)rc);
                SSLEngineConfigurator sslEngineConfigurator = new SSLEngineConfigurator(sslCon, false, false, false);
                this.server = GrizzlyHttpServerFactory.createHttpServer((URI)baseUri, (GrizzlyHttpContainer)container, (boolean)true, (SSLEngineConfigurator)sslEngineConfigurator, (boolean)true);
            } else {
                this.server = GrizzlyHttpServerFactory.createHttpServer((URI)baseUri, (ResourceConfig)rc);
            }
            this.server.start();
        }
        catch (IOException ex) {
            Logger.getLogger(RestCommandProcessor.class.getName()).log(Level.SEVERE, null, ex);
            throw new OpenAS2Exception(ex);
        }
        catch (RuntimeException ex) {
            Logger.getLogger(RestCommandProcessor.class.getName()).log(Level.SEVERE, null, ex);
            throw new OpenAS2Exception(ex);
        }
    }
}

