/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.cmd.processor.restapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.openas2.cert.AliasedCertificateFactory;
import org.openas2.cmd.CommandResult;
import org.openas2.cmd.processor.RestCommandProcessor;

@Path(value="api")
public class ApiResource {
    private final RestCommandProcessor processor;
    @Context
    UriInfo ui;
    @Context
    Request request;
    private final ObjectMapper mapper;

    public ApiResource(RestCommandProcessor processor) {
        this.processor = processor;
        this.mapper = new ObjectMapper();
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    @RolesAllowed(value={"ADMIN"})
    @GET
    @Produces(value={"application/json"})
    public CommandResult getVersion() {
        return new CommandResult("OK", this.processor.getSession().getAppTitle());
    }

    private CommandResult getCertificate(String itemId) throws Exception {
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add("view");
            params.add(itemId);
            CommandResult output = this.processor.feedCommand("cert", params);
            Certificate cert = (Certificate)output.getResults().get(0);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("data", Base64.getEncoder().encodeToString(cert.getEncoded()));
            map.put("alias", itemId);
            output.getResults().set(0, map);
            return output;
        }
        catch (Exception ex) {
            Logger.getLogger(ApiResource.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            throw ex;
        }
    }

    @RolesAllowed(value={"ADMIN"})
    @GET
    @Path(value="/{resource}/{action}{id:(/[^/]+?)?}")
    @Produces(value={"application/json"})
    public CommandResult getCommand(@PathParam(value="resource") String resource, @PathParam(value="action") @DefaultValue(value="list") String action, @PathParam(value="id") String itemId) throws Exception {
        try {
            if (action.equalsIgnoreCase("view") && resource.equalsIgnoreCase("cert") && itemId != null && itemId.length() > 1) {
                return this.getCertificate(itemId.substring(1));
            }
            ArrayList<String> params = new ArrayList<String>();
            if (action != null) {
                params.add(action);
            }
            if (itemId != null && itemId.length() > 1) {
                params.add(itemId.substring(1));
            }
            for (String valueKey : this.ui.getQueryParameters().keySet()) {
                String valueParam = (String)this.ui.getQueryParameters().getFirst((Object)valueKey);
                params.add(valueKey + "=" + valueParam);
            }
            CommandResult output = this.processor.feedCommand(resource, params);
            return output;
        }
        catch (Exception ex) {
            Logger.getLogger(ApiResource.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            throw ex;
        }
    }

    @RolesAllowed(value={"ADMIN"})
    @POST
    @Path(value="/{resource}/{action}{id:(/[^/]+?)?}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public CommandResult postCommand(@PathParam(value="resource") String resource, @PathParam(value="action") @DefaultValue(value="list") String action, @PathParam(value="id") String itemId, MultivaluedMap<String, String> formParams) throws Exception {
        try {
            if (action.equalsIgnoreCase("view") && resource.equalsIgnoreCase("cert")) {
                return this.getCertificate(itemId);
            }
            if (action.equalsIgnoreCase("importbystream") && resource.equalsIgnoreCase("cert")) {
                return this.importCertificateByStream(itemId.substring(1), formParams);
            }
            ArrayList<String> params = new ArrayList<String>();
            if (action != null) {
                params.add(action);
            }
            if (itemId != null && itemId.length() > 1) {
                params.add(itemId.substring(1));
            }
            for (String valueKey : this.ui.getQueryParameters().keySet()) {
                String valueParam = (String)this.ui.getQueryParameters().getFirst((Object)valueKey);
                params.add(valueKey + "=" + valueParam);
            }
            int length = formParams.size();
            for (int index = 0; index < length; ++index) {
                if (!formParams.containsKey((Object)String.valueOf(index))) continue;
                params.add((String)formParams.getFirst((Object)String.valueOf(index)));
                formParams.remove((Object)index);
            }
            for (String valueKey : formParams.keySet()) {
                String valueParam = (String)formParams.getFirst((Object)valueKey);
                params.add(valueKey + "=" + valueParam);
            }
            CommandResult output = this.processor.feedCommand(resource, params);
            return output;
        }
        catch (Exception ex) {
            Logger.getLogger(ApiResource.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            throw ex;
        }
    }

    @RolesAllowed(value={"ADMIN"})
    @PUT
    @Path(value="/{resource}/{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public CommandResult putCommand(@PathParam(value="param") String resource, @PathParam(value="id") String itemId, MultivaluedMap<String, String> formParams) throws Exception {
        return this.postCommand(resource, "add", itemId, formParams);
    }

    @RolesAllowed(value={"ADMIN"})
    @DELETE
    @Path(value="/{resource}/{id}")
    @Produces(value={"application/json"})
    public CommandResult deleteCommand(@PathParam(value="resource") String resource, @PathParam(value="id") String itemId) throws Exception {
        return this.getCommand(resource, "delete", itemId);
    }

    @RolesAllowed(value={"ADMIN"})
    @HEAD
    @Path(value="/{resource}{action:(/[^/]+?)?}{id:(/[^/]+?)?}")
    public Response headCommand(@PathParam(value="param") String command) {
        return Response.status((int)200).build();
    }

    private CommandResult importCertificateByStream(String itemId, MultivaluedMap<String, String> formParams) throws Exception {
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add("importbystream");
            params.add(itemId);
            String payload = (String)formParams.getFirst((Object)"data");
            AliasedCertificateFactory certFx = (AliasedCertificateFactory)this.processor.getSession().getCertificateFactory();
            ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(payload));
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            CommandResult cmdRes = new CommandResult("OK", "Certificate(s) imported successfully");
            while (bais.available() > 0) {
                Certificate cert = cf.generateCertificate(bais);
                if (!(cert instanceof X509Certificate)) continue;
                certFx.addCertificate(itemId, (X509Certificate)cert, true);
                cmdRes.getResults().add("Imported certificate: " + itemId);
                return cmdRes;
            }
            return new CommandResult("ERROR", "No valid X509 certificates found");
        }
        catch (Exception ex) {
            Logger.getLogger(ApiResource.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            throw ex;
        }
    }
}

