/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.cmd.processor.restapi;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.util.encoders.Base64;
import org.openas2.cmd.CommandResult;

@Provider
public class AuthenticationRequestFilter
implements ContainerRequestFilter {
    @Context
    private ResourceInfo resourceInfo;
    private static final String AUTHORIZATION_PROPERTY = "Authorization";
    private static final String AUTHENTICATION_SCHEME = "Basic";
    private static final CommandResult ERROR_ACCESS_DENIED = new CommandResult("ERROR", "You cannot access this resource");
    private static final CommandResult ERROR_ACCESS_FORBIDDEN = new CommandResult("ERROR", "Access blocked for all users !!");
    private String adminUsername;
    private String adminPassword;
    private Log logger = LogFactory.getLog((String)AuthenticationRequestFilter.class.getSimpleName());

    public AuthenticationRequestFilter(String adminUsername, String adminPassword) {
        this.adminUsername = adminUsername;
        this.adminPassword = adminPassword;
    }

    public void filter(ContainerRequestContext requestContext) {
        Method method = this.resourceInfo.getResourceMethod();
        if (!method.isAnnotationPresent(PermitAll.class)) {
            RolesAllowed rolesAnnotation;
            HashSet<String> rolesSet;
            if (method.isAnnotationPresent(DenyAll.class)) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ERROR_ACCESS_FORBIDDEN).build());
                return;
            }
            MultivaluedMap headers = requestContext.getHeaders();
            List authorization = (List)headers.get((Object)AUTHORIZATION_PROPERTY);
            if (authorization == null || authorization.isEmpty()) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ERROR_ACCESS_DENIED).build());
                return;
            }
            String encodedUserPassword = ((String)authorization.get(0)).replaceFirst("Basic ", "");
            String usernameAndPassword = new String(Base64.decode((byte[])encodedUserPassword.getBytes()));
            StringTokenizer tokenizer = new StringTokenizer(usernameAndPassword, ":");
            String username = tokenizer.nextToken();
            String password = tokenizer.nextToken();
            this.logger.info((Object)("Username: " + username));
            if (password.length() > 0) {
                this.logger.info((Object)("password: " + new String(new char[password.length()]).replace("\u0000", "*")));
            } else {
                this.logger.info((Object)"password: <none>");
            }
            if (method.isAnnotationPresent(RolesAllowed.class) && !this.isUserAllowed(username, password, rolesSet = new HashSet<String>(Arrays.asList((rolesAnnotation = method.getAnnotation(RolesAllowed.class)).value())))) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ERROR_ACCESS_DENIED).build());
                return;
            }
        }
    }

    private boolean isUserAllowed(String username, String password, Set<String> rolesSet) {
        String userRole;
        boolean isAllowed = false;
        if (username.equals(this.adminUsername) && password.equals(this.adminPassword) && rolesSet.contains(userRole = "ADMIN")) {
            isAllowed = true;
        }
        return isAllowed;
    }
}

