/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.openas2.lib.util.javamail.ByteArrayDataSource;

public class MimeUtil {
    private static final String HEADER_VALUE_SEPARATOR = ", ";

    public static int getContentLength(InternetHeaders headers) throws IOException {
        String contentLengthStr = MimeUtil.getHeader(headers, "Content-Length");
        if (contentLengthStr == null) {
            throw new IOException("Content-Length missing");
        }
        try {
            return Integer.parseInt(contentLengthStr);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Invalid Content-Length: " + contentLengthStr);
        }
    }

    public static String getHeader(InternetHeaders headers, String key) {
        return MimeUtil.getHeader(headers, key, HEADER_VALUE_SEPARATOR);
    }

    public static String getHeader(InternetHeaders headers, String key, String delimiter) {
        String value = headers.getHeader(key, delimiter);
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase("null")) {
            return null;
        }
        return value;
    }

    public static MimeBodyPart createMimeBodyPart(byte[] data, String contentType, String contentTransferEncoding) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(data, contentType, null)));
        part.setHeader("Content-Type", contentType);
        part.setHeader("Content-Transfer-Encoding", contentTransferEncoding);
        return part;
    }

    public static MimeBodyPart createMimeBodyPart(MimeMultipart multipart) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setContent((Multipart)multipart);
        part.setHeader("Content-Type", multipart.getContentType());
        return part;
    }

    public static MimeMultipart createMimeMultipart(MimeBodyPart bodypart) throws MessagingException {
        return new MimeMultipart(bodypart.getDataHandler().getDataSource());
    }

    public static InternetHeaders readHeaders(InputStream source) throws MessagingException {
        return new InternetHeaders(source);
    }

    public static MimeBodyPart readMimeBodyPart(InputStream source, InternetHeaders headers) throws IOException, MessagingException {
        int contentLength = MimeUtil.getContentLength(headers);
        DataInputStream dataIn = new DataInputStream(source);
        byte[] data = new byte[contentLength];
        dataIn.readFully(data);
        String contentTransferEncoding = MimeUtil.getHeader(headers, "Content-Transfer-Encoding");
        if (contentTransferEncoding == null) {
            contentTransferEncoding = "binary";
        }
        return MimeUtil.createMimeBodyPart(data, MimeUtil.getHeader(headers, "Content-Type"), contentTransferEncoding);
    }

    public static String toString(MimeBodyPart mbp, boolean addDelimiterText) throws IOException, MessagingException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (addDelimiterText) {
            os.write("========BEGIN MIMEBODYPART=========\n".getBytes());
        }
        mbp.writeTo((OutputStream)os);
        if (addDelimiterText) {
            os.write("\n========END MIMEBODYPART=========".getBytes());
        }
        return os.toString();
    }
}

