/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.logging;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openas2.OpenAS2Exception;
import org.openas2.logging.BaseFormatter;
import org.openas2.logging.Level;
import org.openas2.util.DateUtil;

public class DefaultFormatter
extends BaseFormatter {
    public String getTerminatedMessage(OpenAS2Exception exception) {
        StringBuffer buf = new StringBuffer("Termination of exception:" + System.getProperty("line.separator"));
        StringWriter strWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(strWriter);
        exception.printStackTrace(printWriter);
        buf.append(strWriter.toString());
        Map<String, Object> sources = exception.getSources();
        for (Map.Entry<String, Object> source : sources.entrySet()) {
            buf.append(source.getKey()).append(System.getProperty("line.separator"));
            buf.append(source.getValue().toString()).append(System.getProperty("line.separator")).append(System.getProperty("line.separator"));
        }
        return buf.toString();
    }

    @Override
    public void format(Level level, String msg, OutputStream out) {
        PrintWriter writer = new PrintWriter(out);
        writer.print(DateUtil.formatDate(this.dateFormat));
        writer.print(" ");
        writer.print(level.getName().toUpperCase());
        writer.print(" ");
        writer.println(msg);
        writer.flush();
    }

    @Override
    public void format(Throwable t, boolean terminated, OutputStream out) {
        PrintWriter writer = new PrintWriter(out);
        writer.println(this.format(t, terminated));
        writer.println();
        writer.flush();
    }

    @Override
    public String format(Throwable t, boolean terminated) {
        StringBuffer sb = new StringBuffer();
        if (terminated) {
            sb.append("Termination of exception:");
        }
        sb.append(ExceptionUtils.getStackTrace((Throwable)t));
        if (terminated && t instanceof OpenAS2Exception) {
            OpenAS2Exception exception = (OpenAS2Exception)t;
            Map<String, Object> sources = exception.getSources();
            for (Map.Entry<String, Object> source : sources.entrySet()) {
                if (source.getKey() != null) {
                    sb.append(source.getKey());
                } else {
                    sb.append("null key");
                }
                if (source.getValue() != null) {
                    sb.append(source.getValue().toString());
                    continue;
                }
                sb.append("null value");
            }
        }
        return sb.toString();
    }
}

