/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.params;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.params.InvalidParameterException;
import org.openas2.params.ParameterParser;

public class CompositeParameters
extends ParameterParser {
    private Map<String, ParameterParser> parameterParsers;
    private boolean ignoreMissingParsers;
    private Log logger = LogFactory.getLog((String)CompositeParameters.class.getSimpleName());

    public CompositeParameters(boolean ignoreMissingParsers) {
        this.ignoreMissingParsers = ignoreMissingParsers;
    }

    public CompositeParameters(boolean ignoreMissingParsers, Map<String, ParameterParser> parameterParsers) {
        this.ignoreMissingParsers = ignoreMissingParsers;
        this.getParameterParsers().putAll(parameterParsers);
    }

    public CompositeParameters add(String key, ParameterParser param) {
        this.getParameterParsers().put(key, param);
        return this;
    }

    public void setIgnoreMissingParsers(boolean ignoreMissingParsers) {
        this.ignoreMissingParsers = ignoreMissingParsers;
    }

    public boolean getIgnoreMissingParsers() {
        return this.ignoreMissingParsers;
    }

    @Override
    public void setParameter(String key, String value) throws InvalidParameterException {
        StringTokenizer keyParts = new StringTokenizer(key, ".", false);
        keyParts.nextToken();
        ParameterParser parser = this.getParameterParsers().get(keyParts);
        if (parser != null) {
            if (!keyParts.hasMoreTokens()) {
                throw new InvalidParameterException("Invalid key format", this, key, null);
            }
            StringBuffer keyBuf = new StringBuffer(keyParts.nextToken());
            while (keyParts.hasMoreTokens()) {
                keyBuf.append(".");
                keyBuf.append(keyParts.nextToken());
            }
            parser.setParameter(keyBuf.toString(), value);
        } else if (!this.getIgnoreMissingParsers()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Failed to find a parser for: " + key + "  ::: Parser list: " + this.getParameterParsers().keySet().toString()));
            }
            throw new InvalidParameterException("Invalid parser identifier", this, key, value);
        }
    }

    @Override
    public String getParameter(String key) throws InvalidParameterException {
        StringTokenizer keyParts = new StringTokenizer(key, ".", false);
        String parserID = keyParts.nextToken();
        ParameterParser parser = this.getParameterParsers().get(parserID);
        if (parser != null) {
            if (!keyParts.hasMoreTokens()) {
                throw new InvalidParameterException("Invalid key format", this, key, null);
            }
            StringBuffer keyBuf = new StringBuffer(keyParts.nextToken());
            while (keyParts.hasMoreTokens()) {
                keyBuf.append(".");
                keyBuf.append(keyParts.nextToken());
            }
            return parser.getParameter(keyBuf.toString());
        }
        if (!this.getIgnoreMissingParsers()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Failed to find a parser for: " + key + "  ::: Parser list: " + this.getParameterParsers().keySet().toString()));
            }
            throw new InvalidParameterException("Invalid parser identifier", this, key, null);
        }
        return "";
    }

    public void setParameterParsers(Map<String, ParameterParser> parameterParsers) {
        this.parameterParsers = parameterParsers;
    }

    protected Map<String, ParameterParser> getParameterParsers() {
        if (this.parameterParsers == null) {
            this.parameterParsers = new HashMap<String, ParameterParser>();
        }
        return this.parameterParsers;
    }
}

