/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.msgtracking;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.logging.Log;
import org.openas2.message.Message;
import org.openas2.params.ComponentParameters;
import org.openas2.params.CompositeParameters;
import org.openas2.params.ParameterParser;
import org.openas2.processor.msgtracking.BaseMsgTrackingModule;
import org.openas2.processor.msgtracking.EmbeddedDBHandler;
import org.openas2.processor.msgtracking.IDBHandler;
import org.openas2.util.DateUtil;

public class DbTrackingModule
extends BaseMsgTrackingModule {
    public static final String PARAM_TCP_SERVER_START = "tcp_server_start";
    public static final String PARAM_TCP_SERVER_PORT = "tcp_server_port";
    public static final String PARAM_TCP_SERVER_PWD = "tcp_server_password";
    public static final String PARAM_DB_USER = "db_user";
    public static final String PARAM_DB_PWD = "db_pwd";
    public static final String PARAM_DB_NAME = "db_name";
    public static final String PARAM_TABLE_NAME = "table_name";
    public static final String PARAM_DB_DIRECTORY = "db_directory";
    public static final String PARAM_JDBC_CONNECT_STRING = "jdbc_connect_string";
    public static final String PARAM_JDBC_DRIVER = "jdbc_driver";
    public static final String PARAM_JDBC_SERVER_URL = "jdbc_server_url";
    public static final String PARAM_JDBC_PARAMS = "jdbc_extra_paramters";
    public static final String PARAM_SQL_ESCAPE_CHARACTER = "sql_escape_character";
    public static final String PARAM_USE_EMBEDDED_DB = "use_embedded_db";
    public static final String PARAM_FORCE_LOAD_JDBC_DRIVER = "force_load_jdbc_driver";
    private String dbUser = null;
    private String dbPwd = null;
    private String jdbcConnectString = null;
    private String configBaseDir = null;
    private String jdbcDriver = null;
    private boolean isRunning = false;
    private String sqlEscapeChar = "'";
    private boolean useEmbeddedDB = true;
    private boolean forceLoadJdbcDriver = false;
    private String dbPlatform = "h2";
    private String tableName = null;
    IDBHandler dbHandler = null;
    private org.apache.commons.logging.Log logger = LogFactory.getLog((String)DbTrackingModule.class.getSimpleName());

    @Override
    public void init(Session session, Map<String, String> options) throws OpenAS2Exception {
        super.init(session, options);
        CompositeParameters paramParser = this.createParser();
        this.dbUser = this.getParameter(PARAM_DB_USER, true);
        this.dbPwd = this.getParameter(PARAM_DB_PWD, true);
        this.configBaseDir = session.getBaseDirectory();
        this.jdbcConnectString = this.getParameter(PARAM_JDBC_CONNECT_STRING, true);
        this.jdbcConnectString.replace("%home%", this.configBaseDir);
        this.jdbcConnectString = ParameterParser.parse(this.jdbcConnectString, paramParser);
        this.dbPlatform = this.jdbcConnectString.replaceAll(".*jdbc:([^:]*):.*", "$1");
        this.jdbcDriver = this.getParameter(PARAM_JDBC_DRIVER, false);
        this.sqlEscapeChar = this.getParameter(PARAM_SQL_ESCAPE_CHARACTER, "'");
        this.useEmbeddedDB = "true".equals(this.getParameter(PARAM_USE_EMBEDDED_DB, "true"));
        this.forceLoadJdbcDriver = "true".equals(this.getParameter(PARAM_FORCE_LOAD_JDBC_DRIVER, "false"));
        this.tableName = this.getParameter(PARAM_TABLE_NAME, "msg_metadata");
        if (!this.useEmbeddedDB && this.forceLoadJdbcDriver) {
            try {
                Class.forName(this.jdbcDriver);
            }
            catch (ClassNotFoundException e) {
                this.logger.error((Object)("Failed to load JDBC driver: " + this.jdbcDriver), (Throwable)e);
                e.printStackTrace();
                return;
            }
        }
    }

    @Override
    protected String getModuleAction() {
        return "track_msg";
    }

    protected CompositeParameters createParser() {
        CompositeParameters params = new CompositeParameters(true);
        params.add("component", new ComponentParameters(this));
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void persist(Message msg, Map<String, String> map) {
        Connection conn = null;
        try {
            conn = this.useEmbeddedDB ? this.dbHandler.getConnection() : DriverManager.getConnection(this.jdbcConnectString, this.dbUser, this.dbPwd);
            Statement s = conn.createStatement();
            String msgIdField = "msg_id";
            ResultSet rs = s.executeQuery("SELECT * FROM " + this.tableName + " WHERE " + msgIdField + " = '" + map.get(msgIdField) + "'");
            ResultSetMetaData meta = rs.getMetaData();
            boolean isUpdate = rs.next();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("\t\t *** Tracking record found: " + isUpdate + "\n\t\t *** Tracking record metadata: " + meta));
            }
            StringBuffer fieldStmt = new StringBuffer();
            StringBuffer valuesStmt = new StringBuffer();
            for (int i = 0; i < meta.getColumnCount(); ++i) {
                String mapVal;
                String colName = meta.getColumnLabel(i + 1);
                if (colName.equalsIgnoreCase("id")) continue;
                if (colName.equalsIgnoreCase("update_dt")) {
                    if (!isUpdate) continue;
                    this.appendFieldForUpdate(colName, DateUtil.getSqlTimestamp(), fieldStmt, meta.getColumnType(i + 1));
                    continue;
                }
                if (colName.equalsIgnoreCase("create_dt")) {
                    if (isUpdate) {
                        map.remove("create_dt");
                        continue;
                    }
                    this.appendFieldForInsert(colName, DateUtil.getSqlTimestamp(), fieldStmt, valuesStmt, meta.getColumnType(i + 1));
                    continue;
                }
                if (isUpdate) {
                    String dbVal;
                    mapVal = map.get(colName.toLowerCase());
                    if (mapVal == null || (dbVal = rs.getString(colName)) != null && mapVal.equals(dbVal)) continue;
                    this.appendFieldForUpdate(colName, mapVal, fieldStmt, meta.getColumnType(i + 1));
                    continue;
                }
                mapVal = map.get(colName.toLowerCase());
                if (mapVal == null) continue;
                this.appendFieldForInsert(colName, mapVal, fieldStmt, valuesStmt, meta.getColumnType(i + 1));
            }
            if (fieldStmt.length() > 0) {
                String stmt = "";
                stmt = isUpdate ? "UPDATE " + this.tableName + " SET " + fieldStmt.toString() + " WHERE " + "msg_id" + " = '" + map.get(msgIdField) + "'" : "INSERT INTO " + this.tableName + " (" + fieldStmt.toString() + ") VALUES (" + valuesStmt.toString() + ")";
                if (s.executeUpdate(stmt) <= 0) throw new OpenAS2Exception("Failed to persist tracking record to DB: " + map);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Tracking record SQL statement: " + stmt));
                }
                if (!this.logger.isDebugEnabled()) return;
                this.logger.debug((Object)("Tracking record successfully persisted to database: " + map));
                return;
            } else {
                if (!this.logger.isInfoEnabled()) return;
                this.logger.info((Object)("No change from existing record in DB. Tracking record not updated: " + map));
            }
            return;
        }
        catch (Exception e) {
            msg.setLogMsg("Failed to persist a tracking event: " + Log.getExceptionMsg(e) + " ::: Data map: " + map);
            this.logger.error((Object)msg, (Throwable)e);
            return;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String formatField(String value, int dataType) {
        if (value == null) {
            return "NULL";
        }
        switch (dataType) {
            case -6: 
            case -5: 
            case -2: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return value;
            }
            case 91: 
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                if ("oracle".equalsIgnoreCase(this.dbPlatform)) {
                    if (value.length() > 19) {
                        return "TO_TIMESTAMP('" + value + "','YYYY-MM-DD HH24:MI:SS.FF')";
                    }
                    return "TO_DATE('" + value + "','YYYY-MM-DD HH24:MI:SS')";
                }
                if ("mssql".equalsIgnoreCase(this.dbPlatform)) {
                    return "CAST('" + value + "' AS DATETIME)";
                }
                return "'" + value + "'";
            }
        }
        return "'" + value.replaceAll("'", this.sqlEscapeChar + "'") + "'";
    }

    private void appendFieldForUpdate(String name, String value, StringBuffer sb, int dataType) {
        if (sb.length() > 0) {
            sb.append(",");
        }
        sb.append(name).append("=").append(this.formatField(value, dataType));
    }

    private void appendFieldForInsert(String name, String value, StringBuffer names, StringBuffer values, int dataType) {
        if (names.length() > 0) {
            names.append(",");
            values.append(",");
        }
        names.append(name);
        values.append(this.formatField(value, dataType));
    }

    @Override
    public boolean isRunning() {
        if (this.useEmbeddedDB) {
            return this.isRunning;
        }
        return true;
    }

    @Override
    public void start() throws OpenAS2Exception {
        if (!this.useEmbeddedDB) {
            return;
        }
        this.dbHandler = new EmbeddedDBHandler();
        this.dbHandler.start(this.jdbcConnectString, this.dbUser, this.dbPwd, this.getParameters());
        this.isRunning = true;
    }

    @Override
    public void stop() {
        if (!this.useEmbeddedDB) {
            return;
        }
        this.dbHandler.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean healthcheck(List<String> failures) {
        Connection conn = null;
        try {
            conn = this.useEmbeddedDB ? this.dbHandler.getConnection() : DriverManager.getConnection(this.jdbcConnectString, this.dbUser, this.dbPwd);
            Statement s = conn.createStatement();
            ResultSet resultSet = s.executeQuery("SELECT COUNT(*) FROM " + this.tableName);
        }
        catch (Exception e) {
            failures.add(this.getClass().getSimpleName() + " - Failed to check DB tracking module connection to DB: " + e.getMessage() + " :: Connect String: " + this.jdbcConnectString);
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }
}

