/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.receiver;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.app.HealthCheck;
import org.openas2.processor.receiver.HealthCheckModule;
import org.openas2.processor.receiver.NetModule;
import org.openas2.processor.receiver.NetModuleHandler;
import org.openas2.util.HTTPUtil;

public class HealthCheckHandler
implements NetModuleHandler {
    private HealthCheckModule module;
    private Log logger = LogFactory.getLog((String)HealthCheckHandler.class.getSimpleName());

    public HealthCheckHandler(HealthCheckModule module) {
        this.module = module;
    }

    public String getClientInfo(Socket s) {
        return " " + s.getInetAddress().getHostAddress() + " " + s.getPort();
    }

    public HealthCheckModule getModule() {
        return this.module;
    }

    @Override
    public void handle(NetModule owner, Socket s) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Healthcheck connection:  [" + this.getClientInfo(s) + "]"));
        }
        byte[] data = null;
        try {
            List<String> failures;
            InternetHeaders headers = new InternetHeaders();
            ArrayList<String> request = new ArrayList<String>(2);
            data = HTTPUtil.readHTTP(s.getInputStream(), s.getOutputStream(), headers, request);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("HealthCheck received request: " + ((Object)request).toString() + "\n\tHeaders: " + HTTPUtil.printHeaders(headers.getAllHeaders(), "==", ";;") + "\n\tData: " + data));
            }
            if ((failures = new HealthCheck().runCheck(this.module)) == null || failures.isEmpty()) {
                HTTPUtil.sendHTTPResponse(s.getOutputStream(), 200, null);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Healthcheck executed successfully:  [" + this.getClientInfo(s) + "]"));
                }
            } else {
                StringBuilder sb = new StringBuilder("Healthcheck execution failed: ");
                for (int i = 0; i < failures.size(); ++i) {
                    sb.append("\n\t").append(i).append(".").append(failures.get(i));
                }
                HTTPUtil.sendHTTPResponse(s.getOutputStream(), 500, sb.toString());
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)sb);
                }
            }
        }
        catch (Exception e) {
            try {
                HTTPUtil.sendHTTPResponse(s.getOutputStream(), 503, null);
            }
            catch (IOException request) {
                // empty catch block
            }
            String msg = "Unhandled error condition receiving healthcheck.";
            this.logger.error((Object)msg, (Throwable)e);
            return;
        }
    }
}

