/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.resender;

import java.util.Timer;
import java.util.TimerTask;
import org.openas2.OpenAS2Exception;
import org.openas2.processor.BaseActiveModule;
import org.openas2.processor.resender.ResenderModule;

public abstract class BaseResenderModule
extends BaseActiveModule
implements ResenderModule {
    public static final int TICK_INTERVAL = 30000;
    private Timer timer;

    public abstract void resend();

    @Override
    public void doStart() throws OpenAS2Exception {
        this.timer = new Timer(this.getName(), true);
        this.timer.scheduleAtFixedRate((TimerTask)new PollTask(), 0L, 30000L);
    }

    @Override
    public void doStop() throws OpenAS2Exception {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private class PollTask
    extends TimerTask {
        private PollTask() {
        }

        @Override
        public void run() {
            BaseResenderModule.this.resend();
        }
    }
}

