/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;

class ComparableConstant
extends SimplifiedVisitor
implements Comparable,
ConstantVisitor {
    private static final int[] PRIORITIES = new int[19];
    private final Clazz clazz;
    private final int thisIndex;
    private final Constant thisConstant;
    private Constant otherConstant;
    private int result;

    public ComparableConstant(Clazz clazz, int index, Constant constant) {
        this.clazz = clazz;
        this.thisIndex = index;
        this.thisConstant = constant;
    }

    public int getIndex() {
        return this.thisIndex;
    }

    public Constant getConstant() {
        return this.thisConstant;
    }

    public int compareTo(Object other) {
        int otherTag;
        ComparableConstant otherComparableConstant = (ComparableConstant)other;
        this.otherConstant = otherComparableConstant.thisConstant;
        if (this.thisConstant == this.otherConstant) {
            int otherIndex = otherComparableConstant.thisIndex;
            return this.thisIndex < otherIndex ? -1 : (this.thisIndex == otherIndex ? 0 : 1);
        }
        int thisTag = this.thisConstant.getTag();
        if (thisTag != (otherTag = this.otherConstant.getTag())) {
            return PRIORITIES[thisTag] < PRIORITIES[otherTag] ? -1 : 1;
        }
        this.thisConstant.accept(this.clazz, this);
        return this.result;
    }

    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        int otherValue;
        int value = integerConstant.getValue();
        this.result = value < (otherValue = ((IntegerConstant)this.otherConstant).getValue()) ? -1 : (value == otherValue ? 0 : 1);
    }

    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        long otherValue;
        long value = longConstant.getValue();
        this.result = value < (otherValue = ((LongConstant)this.otherConstant).getValue()) ? -1 : (value == otherValue ? 0 : 1);
    }

    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        this.result = Float.compare(floatConstant.getValue(), ((FloatConstant)this.otherConstant).getValue());
    }

    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        this.result = Double.compare(doubleConstant.getValue(), ((DoubleConstant)this.otherConstant).getValue());
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.result = stringConstant.getString(clazz).compareTo(((StringConstant)this.otherConstant).getString(clazz));
    }

    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        this.result = utf8Constant.getString().compareTo(((Utf8Constant)this.otherConstant).getString());
    }

    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        int otherIndex;
        InvokeDynamicConstant otherInvokeDynamicConstant = (InvokeDynamicConstant)this.otherConstant;
        int index = invokeDynamicConstant.getBootstrapMethodAttributeIndex();
        this.result = index < (otherIndex = otherInvokeDynamicConstant.getBootstrapMethodAttributeIndex()) ? -1 : (index > otherIndex ? 1 : (invokeDynamicConstant.getName(clazz) + ' ' + invokeDynamicConstant.getType(clazz)).compareTo(otherInvokeDynamicConstant.getName(clazz) + ' ' + otherInvokeDynamicConstant.getType(clazz)));
    }

    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        int otherKind;
        MethodHandleConstant otherMethodHandleConstant = (MethodHandleConstant)this.otherConstant;
        int kind = methodHandleConstant.getReferenceKind();
        this.result = kind < (otherKind = methodHandleConstant.getReferenceKind()) ? -1 : (kind > otherKind ? 1 : (methodHandleConstant.getName(clazz) + ' ' + methodHandleConstant.getType(clazz)).compareTo(otherMethodHandleConstant.getName(clazz) + ' ' + otherMethodHandleConstant.getType(clazz)));
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        RefConstant otherRefConstant = (RefConstant)this.otherConstant;
        this.result = (refConstant.getClassName(clazz) + ' ' + refConstant.getName(clazz) + ' ' + refConstant.getType(clazz)).compareTo(otherRefConstant.getClassName(clazz) + ' ' + otherRefConstant.getName(clazz) + ' ' + otherRefConstant.getType(clazz));
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.result = classConstant.getName(clazz).compareTo(((ClassConstant)this.otherConstant).getName(clazz));
    }

    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant MethodTypeConstant2) {
        MethodTypeConstant otherMethodTypeConstant = (MethodTypeConstant)this.otherConstant;
        this.result = MethodTypeConstant2.getType(clazz).compareTo(otherMethodTypeConstant.getType(clazz));
    }

    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        NameAndTypeConstant otherNameAndTypeConstant = (NameAndTypeConstant)this.otherConstant;
        this.result = (nameAndTypeConstant.getName(clazz) + ' ' + nameAndTypeConstant.getType(clazz)).compareTo(otherNameAndTypeConstant.getName(clazz) + ' ' + otherNameAndTypeConstant.getType(clazz));
    }

    public boolean equals(Object other) {
        return other != null && this.getClass().equals(other.getClass()) && this.getConstant().getClass().equals(((ComparableConstant)other).getConstant().getClass()) && this.compareTo(other) == 0;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    static {
        ComparableConstant.PRIORITIES[3] = 0;
        ComparableConstant.PRIORITIES[4] = 1;
        ComparableConstant.PRIORITIES[8] = 2;
        ComparableConstant.PRIORITIES[7] = 3;
        ComparableConstant.PRIORITIES[5] = 4;
        ComparableConstant.PRIORITIES[6] = 5;
        ComparableConstant.PRIORITIES[9] = 6;
        ComparableConstant.PRIORITIES[10] = 7;
        ComparableConstant.PRIORITIES[11] = 8;
        ComparableConstant.PRIORITIES[18] = 9;
        ComparableConstant.PRIORITIES[15] = 10;
        ComparableConstant.PRIORITIES[12] = 11;
        ComparableConstant.PRIORITIES[16] = 12;
        ComparableConstant.PRIORITIES[1] = 13;
    }
}

