/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class MultiClassVisitor
implements ClassVisitor {
    private static final int ARRAY_SIZE_INCREMENT = 5;
    private ClassVisitor[] classVisitors;
    private int classVisitorCount;

    public MultiClassVisitor() {
    }

    public MultiClassVisitor(ClassVisitor[] classVisitors) {
        this.classVisitors = classVisitors;
        this.classVisitorCount = classVisitors.length;
    }

    public void addClassVisitor(ClassVisitor classVisitor) {
        this.ensureArraySize();
        this.classVisitors[this.classVisitorCount++] = classVisitor;
    }

    private void ensureArraySize() {
        if (this.classVisitors == null) {
            this.classVisitors = new ClassVisitor[5];
        } else if (this.classVisitors.length == this.classVisitorCount) {
            ClassVisitor[] newClassVisitors = new ClassVisitor[this.classVisitorCount + 5];
            System.arraycopy(this.classVisitors, 0, newClassVisitors, 0, this.classVisitorCount);
            this.classVisitors = newClassVisitors;
        }
    }

    public void visitProgramClass(ProgramClass programClass) {
        for (int index = 0; index < this.classVisitorCount; ++index) {
            this.classVisitors[index].visitProgramClass(programClass);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        for (int index = 0; index < this.classVisitorCount; ++index) {
            this.classVisitors[index].visitLibraryClass(libraryClass);
        }
    }
}

