/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.attribute.CodeAttribute;
import proguard.evaluation.BranchUnit;
import proguard.evaluation.value.InstructionOffsetValue;

public class BasicBranchUnit
implements BranchUnit {
    private boolean wasCalled;
    private InstructionOffsetValue traceBranchTargets;

    public void resetCalled() {
        this.wasCalled = false;
    }

    protected void setCalled() {
        this.wasCalled = true;
    }

    public boolean wasCalled() {
        return this.wasCalled;
    }

    public void setTraceBranchTargets(InstructionOffsetValue branchTargets) {
        this.traceBranchTargets = branchTargets;
    }

    public InstructionOffsetValue getTraceBranchTargets() {
        return this.traceBranchTargets;
    }

    public void branch(Clazz clazz, CodeAttribute codeAttribute, int offset, int branchTarget) {
        this.traceBranchTargets = new InstructionOffsetValue(branchTarget);
        this.wasCalled = true;
    }

    public void branchConditionally(Clazz clazz, CodeAttribute codeAttribute, int offset, int branchTarget, int conditional) {
        this.traceBranchTargets = this.traceBranchTargets.generalize(new InstructionOffsetValue(branchTarget)).instructionOffsetValue();
        this.wasCalled = true;
    }

    public void returnFromMethod() {
        this.traceBranchTargets = InstructionOffsetValue.EMPTY_VALUE;
        this.wasCalled = true;
    }

    public void throwException() {
        this.traceBranchTargets = InstructionOffsetValue.EMPTY_VALUE;
        this.wasCalled = true;
    }
}

