/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.obfuscate.AttributeUsageMarker;

public class ParameterNameMarker
extends SimplifiedVisitor
implements AttributeVisitor {
    private final AttributeVisitor attributeUsageMarker;

    public ParameterNameMarker(AttributeVisitor attributeUsageMarker) {
        this.attributeUsageMarker = attributeUsageMarker;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        if (!AttributeUsageMarker.isUsed(localVariableTableAttribute) && this.hasParameters(clazz, method)) {
            int newIndex = 0;
            for (int index = 0; index < localVariableTableAttribute.u2localVariableTableLength; ++index) {
                LocalVariableInfo localVariableInfo = localVariableTableAttribute.localVariableTable[index];
                if (localVariableInfo.u2startPC != 0) continue;
                localVariableTableAttribute.localVariableTable[newIndex++] = localVariableInfo;
            }
            localVariableTableAttribute.u2localVariableTableLength = newIndex;
            if (newIndex > 0) {
                this.attributeUsageMarker.visitLocalVariableTableAttribute(clazz, method, codeAttribute, localVariableTableAttribute);
            }
        }
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        if (!AttributeUsageMarker.isUsed(localVariableTypeTableAttribute) && this.hasParameters(clazz, method)) {
            int newIndex = 0;
            for (int index = 0; index < localVariableTypeTableAttribute.u2localVariableTypeTableLength; ++index) {
                LocalVariableTypeInfo localVariableTypeInfo = localVariableTypeTableAttribute.localVariableTypeTable[index];
                if (localVariableTypeInfo.u2startPC != 0) continue;
                localVariableTypeTableAttribute.localVariableTypeTable[newIndex++] = localVariableTypeInfo;
            }
            localVariableTypeTableAttribute.u2localVariableTypeTableLength = newIndex;
            if (newIndex > 0) {
                this.attributeUsageMarker.visitLocalVariableTypeTableAttribute(clazz, method, codeAttribute, localVariableTypeTableAttribute);
            }
        }
    }

    private boolean hasParameters(Clazz clazz, Method method) {
        return method.getDescriptor(clazz).charAt(1) != ')';
    }
}

