/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.io.PrintStream;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMember;
import proguard.classfile.ProgramMethod;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.ShortestUsageMark;
import proguard.shrink.ShortestUsageMarker;

public class ShortestUsagePrinter
implements ClassVisitor,
MemberVisitor {
    private final ShortestUsageMarker shortestUsageMarker;
    private final boolean verbose;
    private final PrintStream ps;

    public ShortestUsagePrinter(ShortestUsageMarker shortestUsageMarker) {
        this(shortestUsageMarker, true);
    }

    public ShortestUsagePrinter(ShortestUsageMarker shortestUsageMarker, boolean verbose) {
        this(shortestUsageMarker, verbose, System.out);
    }

    public ShortestUsagePrinter(ShortestUsageMarker shortestUsageMarker, boolean verbose, PrintStream printStream) {
        this.shortestUsageMarker = shortestUsageMarker;
        this.verbose = verbose;
        this.ps = printStream;
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.ps.println(ClassUtil.externalClassName(programClass.getName()));
        this.printReason(programClass);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        this.ps.println(ClassUtil.externalClassName(libraryClass.getName()));
        this.ps.println("  is a library class.\n");
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String name = programField.getName(programClass);
        String type = programField.getDescriptor(programClass);
        this.ps.println(ClassUtil.externalClassName(programClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullFieldDescription(0, name, type) : "." + name) + ShortestUsagePrinter.lineNumberRange(programClass, programField));
        this.printReason(programField);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String name = programMethod.getName(programClass);
        String type = programMethod.getDescriptor(programClass);
        this.ps.println(ClassUtil.externalClassName(programClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullMethodDescription(programClass.getName(), 0, name, type) : "." + name) + ShortestUsagePrinter.lineNumberRange(programClass, programMethod));
        this.printReason(programMethod);
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        String name = libraryField.getName(libraryClass);
        String type = libraryField.getDescriptor(libraryClass);
        this.ps.println(ClassUtil.externalClassName(libraryClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullFieldDescription(0, name, type) : "." + name));
        this.ps.println("  is a library field.\n");
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        String name = libraryMethod.getName(libraryClass);
        String type = libraryMethod.getDescriptor(libraryClass);
        this.ps.println(ClassUtil.externalClassName(libraryClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullMethodDescription(libraryClass.getName(), 0, name, type) : "." + name));
        this.ps.println("  is a library method.\n");
    }

    private void printReason(VisitorAccepter visitorAccepter) {
        if (this.shortestUsageMarker.isUsed(visitorAccepter)) {
            ShortestUsageMark shortestUsageMark = this.shortestUsageMarker.getShortestUsageMark(visitorAccepter);
            this.ps.print("  " + shortestUsageMark.getReason());
            shortestUsageMark.acceptClassVisitor(this);
            shortestUsageMark.acceptMemberVisitor(this);
        } else {
            this.ps.println("  is not being kept.\n");
        }
    }

    private static String lineNumberRange(ProgramClass programClass, ProgramMember programMember) {
        String range = programMember.getLineNumberRange(programClass);
        return range != null ? " (" + range + ")" : "";
    }
}

