/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.standard.Standard;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import nl.talsmasoftware.umldoclet.config.UMLDocletConfig;
import nl.talsmasoftware.umldoclet.logging.GlobalPosition;
import nl.talsmasoftware.umldoclet.logging.LogSupport;
import nl.talsmasoftware.umldoclet.rendering.DiagramRenderer;
import nl.talsmasoftware.umldoclet.rendering.plantuml.PlantumlImageWriter;
import nl.talsmasoftware.umldoclet.rendering.plantuml.PlantumlSupport;

public class UMLDoclet
extends Standard {
    private final RootDoc rootDoc;
    private final UMLDocletConfig config;
    private final SortedSet<PackageDoc> encounteredPackages = new TreeSet<PackageDoc>(new Comparator<PackageDoc>(){

        @Override
        public int compare(PackageDoc o1, PackageDoc o2) {
            return o1 == null ? (o2 == null ? 0 : -1) : (o2 == null ? 1 : o1.name().compareToIgnoreCase(o2.name()));
        }
    });

    public UMLDoclet(RootDoc rootDoc) {
        this.rootDoc = Objects.requireNonNull(rootDoc, "No root document received.");
        this.config = new UMLDocletConfig(rootDoc.options(), (DocErrorReporter)rootDoc);
        LogSupport.info("{0} version {1}", ((Object)((Object)this)).getClass().getSimpleName(), this.config.version());
        LogSupport.trace("Plantuml {0} detected.", PlantumlSupport.isPlantumlDetected() ? "was" : "was not");
        LogSupport.debug("Initialized {0}...", this.config);
    }

    public static LanguageVersion languageVersion() {
        return Standard.languageVersion();
    }

    public static int optionLength(String option) {
        int optionLength = UMLDocletConfig.optionLength(option);
        return optionLength > 0 ? optionLength : Standard.optionLength((String)option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        UMLDocletConfig config = new UMLDocletConfig(options, reporter);
        return Standard.validOptions((String[][])config.standardOptions(), (DocErrorReporter)reporter) && config.isValid();
    }

    public static boolean start(RootDoc rootDoc) {
        UMLDoclet umlDoclet = new UMLDoclet(rootDoc);
        boolean umlDocletResult = umlDoclet.generateUMLDiagrams();
        if (umlDocletResult && !umlDoclet.config.skipStandardDoclet()) {
            return Standard.start((RootDoc)rootDoc);
        }
        return umlDocletResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean generateUMLDiagrams() {
        try (GlobalPosition gp = new GlobalPosition((Doc)this.rootDoc);){
            boolean bl = this.generateIndividualClassDiagrams(this.rootDoc.classes()) && this.generatePackageDiagrams();
            return bl;
        }
        catch (RuntimeException rte) {
            LogSupport.error(rte.getMessage(), rte);
            return false;
        }
    }

    protected boolean generateIndividualClassDiagrams(ClassDoc ... classDocs) {
        LogSupport.debug("Generating class diagrams for all individual classes...", new Object[0]);
        for (ClassDoc classDoc : classDocs) {
            this.encounteredPackages.add(classDoc.containingPackage());
            try (GlobalPosition gp = new GlobalPosition((Doc)classDoc);
                 Writer out = this.createWriterForNewClassFile(classDoc);){
                new DiagramRenderer(this.config).addClass(classDoc).writeTo(out);
            }
            catch (IOException | RuntimeException exception) {
                String message = String.format("Error writing to %s file for %s: %s", this.config.umlFileExtension(), classDoc.qualifiedName(), exception.getMessage());
                if (LogSupport.isTraceEnabled()) {
                    StringWriter stacktrace = new StringWriter();
                    exception.printStackTrace(new PrintWriter(stacktrace));
                    LogSupport.trace("{0}\n{1}", message, stacktrace);
                }
                throw new IllegalStateException(message, exception);
            }
        }
        LogSupport.debug("All individual class diagrams have been generated.", new Object[0]);
        return true;
    }

    protected boolean generatePackageDiagrams() {
        LogSupport.debug("Generating package diagrams for all packages...", new Object[0]);
        for (PackageDoc packageDoc : this.encounteredPackages) {
            try {
                GlobalPosition gp = new GlobalPosition((Doc)packageDoc);
                Throwable throwable = null;
                try {
                    Writer out = this.createWriterForNewPackageFile(packageDoc);
                    Throwable throwable2 = null;
                    try {
                        new DiagramRenderer(this.config).addPackage(packageDoc).writeTo(out);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Throwable out) {
                    throwable = out;
                    throw out;
                }
                finally {
                    if (gp == null) continue;
                    if (throwable != null) {
                        try {
                            gp.close();
                        }
                        catch (Throwable out) {
                            throwable.addSuppressed(out);
                        }
                        continue;
                    }
                    gp.close();
                }
            }
            catch (IOException | RuntimeException exception) {
                String message = String.format("Error writing to %s file for package %s: %s", this.config.umlFileExtension(), packageDoc.name(), exception.getMessage());
                if (LogSupport.isTraceEnabled()) {
                    StringWriter stacktrace = new StringWriter();
                    exception.printStackTrace(new PrintWriter(stacktrace));
                    LogSupport.trace("{0}\n{1}", message, stacktrace);
                }
                throw new IllegalStateException(message, exception);
            }
        }
        LogSupport.debug("All package diagrams have been generated.", new Object[0]);
        return true;
    }

    protected Writer createWriterForNewClassFile(ClassDoc documentedClass) throws IOException {
        return this.createUmlWriterFor(documentedClass.containingPackage().name(), documentedClass.name());
    }

    protected Writer createWriterForNewPackageFile(PackageDoc documentedPackage) throws IOException {
        return this.createUmlWriterFor(documentedPackage.name(), "package");
    }

    private Writer createUmlWriterFor(String qualifiedPackageName, String baseName) throws IOException {
        File umlDirectory;
        File basePath = new File(this.config.basePath());
        File imageDirectory = umlDirectory = UMLDoclet.subDirectory(basePath, qualifiedPackageName, "\\.");
        String imageBaseName = baseName;
        if (this.config.imageDirectory() != null) {
            imageDirectory = UMLDoclet.subDirectory(basePath, this.config.imageDirectory(), "[/\\\\]");
            if (qualifiedPackageName.length() > 0) {
                imageBaseName = qualifiedPackageName + "." + baseName;
            }
        }
        return this.createWriterForUmlFile(umlDirectory, baseName, imageDirectory, imageBaseName);
    }

    private static File subDirectory(File baseDirectory, String subDirectoryName, String separatorRegex) {
        File subDirectory = baseDirectory;
        if (subDirectoryName != null) {
            for (String subdir : subDirectoryName.split(separatorRegex)) {
                if ((subdir = subdir.trim()).length() <= 0) continue;
                subDirectory = new File(subDirectory, subdir);
            }
        }
        return subDirectory;
    }

    private Writer createWriterForUmlFile(File umlDirectory, String umlBaseName, File imgDirectory, String imgBaseName) throws IOException {
        File umlFile = Objects.requireNonNull(umlDirectory, "Directory was null.");
        if ((umlFile.exists() || umlFile.mkdirs()) && ((umlFile = new File(umlFile, umlBaseName + this.config.umlFileExtension())).exists() || umlFile.createNewFile())) {
            LogSupport.info("Generating {0}...", umlFile);
            Writer writer = new OutputStreamWriter((OutputStream)new FileOutputStream(umlFile), this.config.umlFileEncoding());
            String[] imageFormats = this.config.imageFormats();
            if (imageFormats.length > 0 && PlantumlSupport.isPlantumlDetected()) {
                if (!imgDirectory.exists() && !imgDirectory.mkdirs()) {
                    throw new IllegalStateException("Error creating: " + imgDirectory.getPath());
                }
                writer = new PlantumlImageWriter(writer, imgDirectory, imgBaseName, imageFormats);
            }
            return writer;
        }
        throw new IllegalStateException("Error creating: " + umlFile);
    }
}

