/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.config;

import java.util.Arrays;
import nl.talsmasoftware.umldoclet.config.AbstractSetting;
import nl.talsmasoftware.umldoclet.logging.LogSupport;

class BooleanSetting
extends AbstractSetting<Boolean> {
    private final boolean defaultValue;

    BooleanSetting(String name, boolean defaultValue) {
        super(name);
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean validate(String[] option) {
        if (option.length != 2) {
            LogSupport.error("Expected {0} but received {1} values: {2}.", 2, option.length, Arrays.toString(option));
            return false;
        }
        if (!"true".equalsIgnoreCase(option[1]) && !"false".equalsIgnoreCase(option[1])) {
            LogSupport.error("Expected boolean value, but got \"{0}\" for option \"{1}\".", option[1], option[0]);
            return false;
        }
        return true;
    }

    @Override
    public Boolean parse(String[] option, Object currentValue) {
        return option.length > 1 ? Boolean.valueOf(option[1]) : this.value(currentValue);
    }

    @Override
    public Boolean value(Object configured) {
        return configured instanceof Boolean ? (Boolean)configured : this.defaultValue;
    }
}

