/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.config;

import java.util.Arrays;
import nl.talsmasoftware.umldoclet.config.AbstractSetting;
import nl.talsmasoftware.umldoclet.logging.LogSupport;

class IntegerSetting
extends AbstractSetting<Integer> {
    private final int defaultValue;

    IntegerSetting(String name, int defaultValue) {
        super(name);
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean validate(String[] option) {
        if (option.length != 2) {
            LogSupport.error("Expected {0} but received {1} values: {2}.", 2, option.length, Arrays.toString(option));
            return false;
        }
        try {
            LogSupport.trace("Valid integer option \"{0}\": {1}", option[0], Integer.valueOf(option[1]));
        }
        catch (NumberFormatException badInteger) {
            LogSupport.trace("Invalid integer option \"{0}\": {1}", option[0], badInteger);
            LogSupport.error("Expected boolean value, but got \"{0}\" for option \"{1}\".", option[1], option[0]);
            return false;
        }
        return true;
    }

    @Override
    public Integer parse(String[] option, Object currentValue) {
        return option.length > 1 ? Integer.valueOf(option[1]) : this.value(currentValue);
    }

    @Override
    public Integer value(Object configured) {
        return configured instanceof Integer ? (Integer)configured : this.defaultValue;
    }
}

