/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import nl.talsmasoftware.umldoclet.config.AbstractSetting;
import nl.talsmasoftware.umldoclet.logging.LogSupport;

class ListSetting
extends AbstractSetting<List<String>> {
    private final List<String> defaultValue;

    ListSetting(String name, String ... defaultValue) {
        super(name);
        this.defaultValue = ListSetting.unmodifiableCopy(ListSetting.split(false, defaultValue));
    }

    @Override
    public boolean validate(String[] option) {
        if (option.length < 2) {
            LogSupport.error("Expected at least {0} but received {1} values: {2}.", 2, option.length, Arrays.toString(option));
            return false;
        }
        return true;
    }

    @Override
    public List<String> parse(String[] option, Object currentValue) {
        ArrayList<String> values = new ArrayList<String>();
        if (option.length > 1) {
            if (currentValue instanceof Iterable) {
                for (Object val : (Iterable)currentValue) {
                    values.add(Objects.toString(val));
                }
            }
            values.addAll(ListSetting.split(true, option));
        }
        if (values.isEmpty()) {
            return this.value(currentValue);
        }
        return ListSetting.unmodifiableCopy(values);
    }

    @Override
    public List<String> value(Object configured) {
        return configured instanceof List ? (List<String>)configured : this.defaultValue;
    }

    private static List<String> split(boolean skipfirst, String ... values) {
        ArrayList<String> result = new ArrayList<String>();
        boolean skip = skipfirst;
        for (String val : values) {
            if (!skip) {
                result.addAll(Arrays.asList(val.trim().split("\\s*[,;\\n]\\s*")));
            }
            skip = false;
        }
        return result;
    }

    private static List<String> unmodifiableCopy(Collection<?> source) {
        if (source == null) {
            return null;
        }
        if (source.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> copy = new ArrayList<String>(source.size());
        for (Object value : source) {
            if (value == null) continue;
            copy.add(value.toString());
        }
        return copy.size() == 1 ? Collections.singletonList(copy.get(0)) : Collections.unmodifiableList(copy);
    }
}

