/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.config;

import java.util.Arrays;
import nl.talsmasoftware.umldoclet.config.AbstractSetting;
import nl.talsmasoftware.umldoclet.logging.LogSupport;

class StringSetting
extends AbstractSetting<String> {
    private static final String NONE = "none";
    private final String defaultValue;

    StringSetting(String name, String defaultValue) {
        super(name);
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean validate(String[] option) {
        if (option.length != 2) {
            LogSupport.error("Expected {0} but received {1} values: {2}.", 2, option.length, Arrays.toString(option));
            return false;
        }
        return true;
    }

    @Override
    public String parse(String[] option, Object currentValue) {
        return option.length > 1 ? option[1] : this.value(currentValue);
    }

    @Override
    public String value(Object configured) {
        return configured == null || NONE.equals(configured) ? this.defaultValue : configured.toString();
    }
}

