/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.config;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.ProgramElementDoc;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import nl.talsmasoftware.umldoclet.config.AbstractSetting;
import nl.talsmasoftware.umldoclet.config.BooleanSetting;
import nl.talsmasoftware.umldoclet.config.IntegerSetting;
import nl.talsmasoftware.umldoclet.config.ListSetting;
import nl.talsmasoftware.umldoclet.config.StringSetting;
import nl.talsmasoftware.umldoclet.logging.LogSupport;
import nl.talsmasoftware.umldoclet.model.Model;
import nl.talsmasoftware.umldoclet.rendering.indent.Indentation;

public class UMLDocletConfig
extends EnumMap<Setting, Object> {
    private final boolean valid;
    private final String[][] standardOptions;
    private final Properties properties;

    public UMLDocletConfig(String[][] options, DocErrorReporter reporter) {
        super(Setting.class);
        boolean allOptionsValid = true;
        LogSupport.setReporter(reporter);
        ArrayList<String[]> stdOpts = new ArrayList<String[]>();
        for (String[] option : options) {
            Setting setting = Setting.forOption(option);
            if (setting == null) {
                stdOpts.add(option);
                continue;
            }
            if (setting.delegate.validate(option)) {
                this.put(setting, setting.delegate.parse(option, this.get((Object)setting)));
                continue;
            }
            allOptionsValid = false;
        }
        this.valid = allOptionsValid;
        this.standardOptions = (String[][])stdOpts.toArray((T[])new String[stdOpts.size()][]);
        LogSupport.setLevel(Setting.UML_LOGLEVEL.value(this));
        try {
            String basePath = (String)Setting.UML_BASE_PATH.value(this);
            LogSupport.trace("Configured UML base path: \"{0}\".", basePath);
            if (basePath.startsWith("file:")) {
                basePath = basePath.substring("file:".length());
                if (!"/".equals(File.separator)) {
                    basePath = basePath.replaceAll("/", Matcher.quoteReplacement(File.separator));
                }
                LogSupport.trace("Translated UML base path: \"{0}\".", basePath);
            }
            this.put(Setting.UML_BASE_PATH, new File(basePath).getCanonicalPath());
        }
        catch (IOException ioe) {
            LogSupport.warn("Error converting base path \"{0}\" to a canonical path: {1}", Setting.UML_BASE_PATH.value(this), ioe);
        }
        this.properties = new Properties();
        try (InputStream in = this.getClass().getResourceAsStream("/META-INF/umldoclet.properties");){
            this.properties.load(in);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("I/O exception loading UML Doclet properties: " + ioe.getMessage(), ioe);
        }
    }

    public static int optionLength(String option) {
        return Setting.forOption(new String[]{option}) == null ? 0 : 2;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String version() {
        return this.properties.getProperty("version", "<unknown version>");
    }

    public String basePath() {
        return (String)Setting.UML_BASE_PATH.value(this);
    }

    public Indentation indentation() {
        String value = (String)Setting.UML_INDENTATION.value(this);
        try {
            return "tabs".equalsIgnoreCase(value) ? Indentation.tabs(0) : Indentation.spaces(Integer.valueOf(value), 0);
        }
        catch (NumberFormatException badInteger) {
            LogSupport.trace("Invalid integer option \"{0}\": {1}", value, badInteger);
            LogSupport.error("Expected boolean value, but got \"{0}\" for option \"{1}\".", value, ((Setting)Setting.UML_INDENTATION).delegate.name);
            return Indentation.DEFAULT;
        }
    }

    public String umlFileExtension() {
        String extension = (String)Setting.UML_FILE_EXTENSION.value(this);
        return extension.startsWith(".") ? extension : "." + extension;
    }

    public String umlFileEncoding() {
        String encoding = (String)Setting.UML_FILE_ENCODING.value(this);
        if (encoding == null) {
            for (String[] stdOption : this.standardOptions) {
                if (stdOption.length <= 1 || !"-docEncoding".equalsIgnoreCase(stdOption[0])) continue;
                encoding = stdOption[1];
                LogSupport.debug("Setting UML file encoding to \"{0}\" from standard Doclet option \"{1}\", because \"{2}\" was not specified.", encoding, "-docEncoding", "-" + ((Setting)Setting.UML_FILE_ENCODING).delegate.name);
                break;
            }
            if (encoding == null) {
                encoding = "UTF-8";
                LogSupport.debug("Setting UML file encoding to \"{0}\" by default.", encoding);
            }
            this.put(Setting.UML_FILE_ENCODING, encoding);
        }
        return encoding;
    }

    public boolean skipStandardDoclet() {
        return (Boolean)Setting.UML_SKIP_STANDARD_DOCLET.value(this);
    }

    public boolean includePrivateFields() {
        return (Boolean)Setting.UML_INCLUDE_PRIVATE_FIELDS.value(this);
    }

    public boolean includePackagePrivateFields() {
        return (Boolean)Setting.UML_INCLUDE_PACKAGE_PRIVATE_FIELDS.value(this);
    }

    public boolean includeProtectedFields() {
        return (Boolean)Setting.UML_INCLUDE_PROTECTED_FIELDS.value(this);
    }

    public boolean includePublicFields() {
        return (Boolean)Setting.UML_INCLUDE_PUBLIC_FIELDS.value(this);
    }

    public boolean includeDeprecatedFields() {
        return (Boolean)Setting.UML_INCLUDE_DEPRECATED_FIELDS.value(this);
    }

    public boolean includeFieldTypes() {
        return (Boolean)Setting.UML_INCLUDE_FIELD_TYPES.value(this);
    }

    public boolean includeMethodParams() {
        return this.includeMethodParamNames() || this.includeMethodParamTypes();
    }

    public boolean includeMethodParamNames() {
        return (Boolean)Setting.UML_INCLUDE_METHOD_PARAM_NAMES.value(this);
    }

    public boolean includeMethodParamTypes() {
        return (Boolean)Setting.UML_INCLUDE_METHOD_PARAM_TYPES.value(this);
    }

    public boolean includeMethodReturntypes() {
        return (Boolean)Setting.UML_INCLUDE_METHOD_RETURNTYPES.value(this);
    }

    public boolean includeConstructors() {
        return (Boolean)Setting.UML_INCLUDE_CONSTRUCTORS.value(this);
    }

    public boolean includeDefaultConstructors() {
        return (Boolean)Setting.UML_INCLUDE_DEFAULT_CONSTRUCTORS.value(this);
    }

    public boolean includePrivateMethods() {
        return (Boolean)Setting.UML_INCLUDE_PRIVATE_METHODS.value(this);
    }

    public boolean includePackagePrivateMethods() {
        return (Boolean)Setting.UML_INCLUDE_PACKAGE_PRIVATE_METHODS.value(this);
    }

    public boolean includeProtectedMethods() {
        return (Boolean)Setting.UML_INCLUDE_PROTECTED_METHODS.value(this);
    }

    public boolean includePublicMethods() {
        return (Boolean)Setting.UML_INCLUDE_PUBLIC_METHODS.value(this);
    }

    public boolean includeDeprecatedMethods() {
        return (Boolean)Setting.UML_INCLUDE_DEPRECATED_METHODS.value(this);
    }

    public boolean includeAbstractSuperclassMethods() {
        return (Boolean)Setting.UML_INCLUDE_ABSTRACT_SUPERCLASS_METHODS.value(this);
    }

    private boolean includePrivateClasses() {
        return (Boolean)Setting.UML_INCLUDE_PRIVATE_CLASSES.value(this);
    }

    private boolean includePackagePrivateClasses() {
        return (Boolean)Setting.UML_INCLUDE_PACKAGE_PRIVATE_CLASSES.value(this);
    }

    private boolean includeProtectedClasses() {
        return (Boolean)Setting.UML_INCLUDE_PROTECTED_CLASSES.value(this);
    }

    private boolean includeDeprecatedClasses() {
        return (Boolean)Setting.UML_INCLUDE_DEPRECATED_CLASSES.value(this);
    }

    private boolean includePrivateInnerclasses() {
        return (Boolean)Setting.UML_INCLUDE_PRIVATE_INNERCLASSES.value(this);
    }

    private boolean includePackagePrivateInnerclasses() {
        return (Boolean)Setting.UML_INCLUDE_PACKAGE_PRIVATE_INNERCLASSES.value(this);
    }

    private boolean includeProtectedInnerclasses() {
        return (Boolean)Setting.UML_INCLUDE_PROTECTED_INNERCLASSES.value(this);
    }

    public boolean includeHyperlinks() {
        String explicit = (String)Setting.UML_INCLUDE_HYPERLINKS.value(this);
        return explicit != null ? Boolean.valueOf(explicit) : !this.skipStandardDoclet();
    }

    public boolean includeClass(ClassDoc classDoc) {
        boolean isInnerclass;
        if (classDoc == null) {
            LogSupport.warn("Encountered <null> class documentation!", new Object[0]);
            return false;
        }
        boolean included = true;
        boolean bl = isInnerclass = classDoc.containingClass() != null;
        if (classDoc.isPrivate() && (!this.includePrivateClasses() || isInnerclass && !this.includePrivateInnerclasses())) {
            LogSupport.trace("Not including private class \"{0}\".", classDoc.qualifiedName());
            included = false;
        } else if (classDoc.isPackagePrivate() && (!this.includePackagePrivateClasses() || isInnerclass && !this.includePackagePrivateInnerclasses())) {
            LogSupport.debug("Not including package-private class \"{0}\".", classDoc.qualifiedName());
            included = false;
        } else if (classDoc.isProtected() && (!this.includeProtectedClasses() || isInnerclass && !this.includeProtectedInnerclasses())) {
            LogSupport.debug("Not including protected class \"{0}\".", classDoc.qualifiedName());
            included = false;
        } else if (Model.isDeprecated((ProgramElementDoc)classDoc) && !this.includeDeprecatedClasses()) {
            LogSupport.debug("Not including deprecated class \"{0}\".", classDoc.qualifiedName());
            included = false;
        }
        LogSupport.trace("{0} class \"{1}\".", included ? "Including" : "Not including", classDoc.qualifiedName());
        return included;
    }

    public Collection<String> excludedReferences() {
        return (Collection)Setting.UML_EXCLUDED_REFERENCES.value(this);
    }

    public boolean includeOverridesFromExcludedReferences() {
        return (Boolean)Setting.UML_INCLUDE_OVERRIDES_FROM_EXCLUDED_REFERENCES.value(this);
    }

    public boolean alwaysUseQualifiedClassnames() {
        return (Boolean)Setting.UML_ALWAYS_USE_QUALIFIED_CLASSNAMES.value(this);
    }

    public List<String> umlCommands() {
        return (List)Setting.UML_COMMAND.value(this);
    }

    public boolean supportLegacyTags() {
        return true;
    }

    public boolean includeDisabledFields() {
        return false;
    }

    public String[] imageFormats() {
        List imageFormats = (List)Setting.UML_IMAGE_FORMAT.value(this);
        return imageFormats.toArray(new String[imageFormats.size()]);
    }

    public String imageDirectory() {
        return (String)Setting.UML_IMAGE_DIRECTORY.value(this);
    }

    public boolean usePackageDependencies() {
        return (Boolean)Setting.UML_PACKAGE_DEPENDENCIES.value(this);
    }

    public String[][] standardOptions() {
        return this.standardOptions;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName()).append(super.toString()).append(",StandardOptions{");
        String sep = "";
        for (String[] option : this.standardOptions) {
            if (option.length <= 0) continue;
            result.append(sep).append(option[0]);
            if (option.length > 1) {
                result.append(":").append(option[1]);
            }
            for (int i = 2; i < option.length; ++i) {
                result.append(' ').append(option[i]);
            }
            sep = ", ";
        }
        return result.append('}').toString();
    }

    static enum Setting {
        UML_LOGLEVEL("umlLogLevel", "INFO"),
        UML_INDENTATION("umlIndentation", "-1"),
        UML_BASE_PATH("umlBasePath", "."),
        UML_FILE_EXTENSION("umlFileExtension", ".puml"),
        UML_FILE_ENCODING("umlFileEncoding", null),
        UML_SKIP_STANDARD_DOCLET("umlSkipStandardDoclet", false),
        UML_INCLUDE_PRIVATE_FIELDS("umlIncludePrivateFields", false),
        UML_INCLUDE_PACKAGE_PRIVATE_FIELDS("umlIncludePackagePrivateFields", false),
        UML_INCLUDE_PROTECTED_FIELDS("umlIncludeProtectedFields", true),
        UML_INCLUDE_PUBLIC_FIELDS("umlIncludePublicFields", true),
        UML_INCLUDE_DEPRECATED_FIELDS("umlIncludeDeprecatedFields", false),
        UML_INCLUDE_FIELD_TYPES("umlIncludeFieldTypes", true),
        UML_INCLUDE_METHOD_PARAM_NAMES("umlIncludeMethodParamNames", false),
        UML_INCLUDE_METHOD_PARAM_TYPES("umlIncludeMethodParamTypes", true),
        UML_INCLUDE_METHOD_RETURNTYPES("umlIncludeMethodReturntypes", true),
        UML_INCLUDE_CONSTRUCTORS("umlIncludeConstructors", true),
        UML_INCLUDE_DEFAULT_CONSTRUCTORS("umlIncludeDefaultConstructors", false),
        UML_INCLUDE_PRIVATE_METHODS("umlIncludePrivateMethods", false),
        UML_INCLUDE_PACKAGE_PRIVATE_METHODS("umlIncludePackagePrivateMethods", false),
        UML_INCLUDE_PROTECTED_METHODS("umlIncludeProtectedMethods", true),
        UML_INCLUDE_PUBLIC_METHODS("umlIncludePublicMethods", true),
        UML_INCLUDE_DEPRECATED_METHODS("umlIncludeDeprecatedMethods", false),
        UML_INCLUDE_ABSTRACT_SUPERCLASS_METHODS("umlIncludeAbstractSuperclassMethods", true),
        UML_INCLUDE_PRIVATE_CLASSES("umlIncludePrivateClasses", false),
        UML_INCLUDE_PACKAGE_PRIVATE_CLASSES("umlIncludePackagePrivateClasses", false),
        UML_INCLUDE_PROTECTED_CLASSES("umlIncludeProtectedClasses", true),
        UML_INCLUDE_DEPRECATED_CLASSES("umlIncludeDeprecatedClasses", false),
        UML_INCLUDE_PRIVATE_INNERCLASSES("umlIncludePrivateInnerClasses", false),
        UML_INCLUDE_PACKAGE_PRIVATE_INNERCLASSES("umlIncludePackagePrivateInnerClasses", false),
        UML_INCLUDE_PROTECTED_INNERCLASSES("umlIncludeProtectedInnerClasses", false),
        UML_EXCLUDED_REFERENCES(new ListSetting("umlExcludedReferences", "java.lang.Object", "java.lang.Enum", "java.lang.annotation.Annotation")),
        UML_INCLUDE_OVERRIDES_FROM_EXCLUDED_REFERENCES("umlIncludeOverridesFromExcludedReferences", false),
        UML_PACKAGE_DEPENDENCIES("umlPackageDependencies", true),
        UML_INCLUDE_HYPERLINKS("umlIncludeHyperlinks", null),
        UML_COMMAND(new ListSetting("umlCommand", new String[0])),
        UML_ALWAYS_USE_QUALIFIED_CLASSNAMES("umlAlwaysUseQualifiedClassnames", false),
        UML_IMAGE_FORMAT(new ListSetting("umlImageFormat", new String[0])),
        UML_IMAGE_DIRECTORY("umlImageDirectory", null);

        private final AbstractSetting<?> delegate;

        private Setting(String name, String defaultValue) {
            this(new StringSetting(name, defaultValue));
        }

        private Setting(String name, boolean defaultValue) {
            this(new BooleanSetting(name, defaultValue));
        }

        private Setting(String name, int defaultValue) {
            this(new IntegerSetting(name, defaultValue));
        }

        private Setting(AbstractSetting delegate) {
            this.delegate = delegate;
        }

        private static Setting forOption(String ... option) {
            if (option != null && option.length > 0) {
                for (Setting setting : Setting.values()) {
                    if (!setting.delegate.matches(option[0])) continue;
                    return setting;
                }
            }
            return null;
        }

        <T> T value(UMLDocletConfig config) {
            return (T)this.delegate.value(config.get((Object)this));
        }
    }
}

